
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "ingress"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class LoadBalancerStatus {

    /**
     * load-balancer ingress points
     * 
     */
    @JsonProperty("ingress")
    @Valid
    private List<LoadBalancerIngress> ingress = new ArrayList<LoadBalancerIngress>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public LoadBalancerStatus() {
    }

    /**
     * 
     * @param ingress
     */
    public LoadBalancerStatus(List<LoadBalancerIngress> ingress) {
        this.ingress = ingress;
    }

    /**
     * load-balancer ingress points
     * 
     * @return
     *     The ingress
     */
    @JsonProperty("ingress")
    public List<LoadBalancerIngress> getIngress() {
        return ingress;
    }

    /**
     * load-balancer ingress points
     * 
     * @param ingress
     *     The ingress
     */
    @JsonProperty("ingress")
    public void setIngress(List<LoadBalancerIngress> ingress) {
        this.ingress = ingress;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(ingress).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof LoadBalancerStatus) == false) {
            return false;
        }
        LoadBalancerStatus rhs = ((LoadBalancerStatus) other);
        return new EqualsBuilder().append(ingress, rhs.ingress).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
