
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "accessModes",
    "resources",
    "volumeName"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class PersistentVolumeClaimSpec {

    /**
     * the desired access modes the volume should have
     * 
     */
    @JsonProperty("accessModes")
    @Valid
    private List<String> accessModes = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("resources")
    @Valid
    private ResourceRequirements resources;
    /**
     * the binding reference to the persistent volume backing this claim
     * 
     */
    @JsonProperty("volumeName")
    private String volumeName;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public PersistentVolumeClaimSpec() {
    }

    /**
     * 
     * @param accessModes
     * @param resources
     * @param volumeName
     */
    public PersistentVolumeClaimSpec(List<String> accessModes, ResourceRequirements resources, String volumeName) {
        this.accessModes = accessModes;
        this.resources = resources;
        this.volumeName = volumeName;
    }

    /**
     * the desired access modes the volume should have
     * 
     * @return
     *     The accessModes
     */
    @JsonProperty("accessModes")
    public List<String> getAccessModes() {
        return accessModes;
    }

    /**
     * the desired access modes the volume should have
     * 
     * @param accessModes
     *     The accessModes
     */
    @JsonProperty("accessModes")
    public void setAccessModes(List<String> accessModes) {
        this.accessModes = accessModes;
    }

    /**
     * 
     * 
     * @return
     *     The resources
     */
    @JsonProperty("resources")
    public ResourceRequirements getResources() {
        return resources;
    }

    /**
     * 
     * 
     * @param resources
     *     The resources
     */
    @JsonProperty("resources")
    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    /**
     * the binding reference to the persistent volume backing this claim
     * 
     * @return
     *     The volumeName
     */
    @JsonProperty("volumeName")
    public String getVolumeName() {
        return volumeName;
    }

    /**
     * the binding reference to the persistent volume backing this claim
     * 
     * @param volumeName
     *     The volumeName
     */
    @JsonProperty("volumeName")
    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(accessModes).append(resources).append(volumeName).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof PersistentVolumeClaimSpec) == false) {
            return false;
        }
        PersistentVolumeClaimSpec rhs = ((PersistentVolumeClaimSpec) other);
        return new EqualsBuilder().append(accessModes, rhs.accessModes).append(resources, rhs.resources).append(volumeName, rhs.volumeName).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
