package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class DeploymentCauseImageTriggerBuilder extends DeploymentCauseImageTriggerFluent<DeploymentCauseImageTriggerBuilder> implements VisitableBuilder<DeploymentCauseImageTrigger,DeploymentCauseImageTriggerBuilder>{

     DeploymentCauseImageTriggerFluent<?> fluent;
public DeploymentCauseImageTriggerBuilder(){
    this(new DeploymentCauseImageTrigger());
}
public DeploymentCauseImageTriggerBuilder( DeploymentCauseImageTriggerFluent<?> fluent ){
    this(fluent, new DeploymentCauseImageTrigger());
}
public DeploymentCauseImageTriggerBuilder( DeploymentCauseImageTriggerFluent<?> fluent , DeploymentCauseImageTrigger instance ){
    this.fluent = fluent; fluent.withFrom(instance.getFrom()); 
}
public DeploymentCauseImageTriggerBuilder( DeploymentCauseImageTrigger instance ){
    this.fluent = this; this.withFrom(instance.getFrom()); 
}

public EditableDeploymentCauseImageTrigger build(){
    EditableDeploymentCauseImageTrigger buildable = new EditableDeploymentCauseImageTrigger(fluent.getFrom());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    