package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class EnvVarFluent<T extends EnvVarFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String name;     String value;     VisitableBuilder<EnvVarSource, ?> valueFrom;     Map<String, Object> additionalProperties = new HashMap();

    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public String getValue(){
    return this.value;
    }
    public T withValue( String value){
    this.value=value; return (T) this;
    }
    public EnvVarSource getValueFrom(){
    return this.valueFrom!=null?this.valueFrom.build():null;
    }
    public T withValueFrom( EnvVarSource valueFrom){
    if (valueFrom!=null){ this.valueFrom= new EnvVarSourceBuilder(valueFrom); _visitables.add(this.valueFrom);} return (T) this;
    }
    public ValueFromNested<T> withNewValueFrom(){
    return new ValueFromNested<T>();
    }
    public ValueFromNested<T> withNewValueFromLike( EnvVarSource item){
    return new ValueFromNested<T>(item);
    }
    public ValueFromNested<T> editValueFrom(){
    return withNewValueFromLike(getValueFrom());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class ValueFromNested<N> extends EnvVarSourceFluent<ValueFromNested<N>> implements Nested<N>{

        private final EnvVarSourceBuilder builder;
    
             ValueFromNested ( EnvVarSource item){
        this.builder = new EnvVarSourceBuilder(this, item);
        }
             ValueFromNested (){
        this.builder = new EnvVarSourceBuilder(this);
        }
    
            public N endValueFrom(){
            return and();
        }
            public N and(){
            return (N) EnvVarFluent.this.withValueFrom(builder.build());
        }
    
}


}
