package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public class BuildConfigFluent<T extends BuildConfigFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     BuildConfig.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<BuildConfigSpec, ?> spec;     VisitableBuilder<BuildConfigStatus, ?> status;     Map<String, Object> additionalProperties = new HashMap();

    public BuildConfig.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( BuildConfig.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public BuildConfigSpec getSpec(){
    return this.spec!=null?this.spec.build():null;
    }
    public T withSpec( BuildConfigSpec spec){
    if (spec!=null){ this.spec= new BuildConfigSpecBuilder(spec); _visitables.add(this.spec);} return (T) this;
    }
    public SpecNested<T> withNewSpec(){
    return new SpecNested<T>();
    }
    public SpecNested<T> withNewSpecLike( BuildConfigSpec item){
    return new SpecNested<T>(item);
    }
    public SpecNested<T> editSpec(){
    return withNewSpecLike(getSpec());
    }
    public BuildConfigStatus getStatus(){
    return this.status!=null?this.status.build():null;
    }
    public T withStatus( BuildConfigStatus status){
    if (status!=null){ this.status= new BuildConfigStatusBuilder(status); _visitables.add(this.status);} return (T) this;
    }
    public StatusNested<T> withNewStatus(){
    return new StatusNested<T>();
    }
    public StatusNested<T> withNewStatusLike( BuildConfigStatus item){
    return new StatusNested<T>(item);
    }
    public StatusNested<T> editStatus(){
    return withNewStatusLike(getStatus());
    }
    public T withNewStatus( Integer lastVersion){
    return withStatus(new BuildConfigStatus(lastVersion));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) BuildConfigFluent.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SpecNested<N> extends BuildConfigSpecFluent<SpecNested<N>> implements Nested<N>{

        private final BuildConfigSpecBuilder builder;
    
             SpecNested ( BuildConfigSpec item){
        this.builder = new BuildConfigSpecBuilder(this, item);
        }
             SpecNested (){
        this.builder = new BuildConfigSpecBuilder(this);
        }
    
            public N endSpec(){
            return and();
        }
            public N and(){
            return (N) BuildConfigFluent.this.withSpec(builder.build());
        }
    
}
    public class StatusNested<N> extends BuildConfigStatusFluent<StatusNested<N>> implements Nested<N>{

        private final BuildConfigStatusBuilder builder;
    
             StatusNested ( BuildConfigStatus item){
        this.builder = new BuildConfigStatusBuilder(this, item);
        }
             StatusNested (){
        this.builder = new BuildConfigStatusBuilder(this);
        }
    
            public N and(){
            return (N) BuildConfigFluent.this.withStatus(builder.build());
        }
            public N endStatus(){
            return and();
        }
    
}


}
