package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ImageStreamSpecFluent<T extends ImageStreamSpecFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String dockerImageRepository;     List<VisitableBuilder<NamedTagReference, ?>> tags = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public String getDockerImageRepository(){
    return this.dockerImageRepository;
    }
    public T withDockerImageRepository( String dockerImageRepository){
    this.dockerImageRepository=dockerImageRepository; return (T) this;
    }
    public T addToTags( NamedTagReference item){
    if (item != null) {NamedTagReferenceBuilder builder = new NamedTagReferenceBuilder(item);_visitables.add(builder);this.tags.add(builder);} return (T)this;
    }
    public List<NamedTagReference> getTags(){
    return build(tags);
    }
    public T withTags( List<NamedTagReference> tags){
    this.tags.clear();if (tags != null) {for (NamedTagReference item : tags){this.addToTags(item);}} return (T) this;
    }
    public TagsNested<T> addNewTag(){
    return new TagsNested<T>();
    }
    public TagsNested<T> addNewTagLike( NamedTagReference item){
    return new TagsNested<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class TagsNested<N> extends NamedTagReferenceFluent<TagsNested<N>> implements Nested<N>{

        private final NamedTagReferenceBuilder builder;
    
             TagsNested (){
        this.builder = new NamedTagReferenceBuilder(this);
        }
             TagsNested ( NamedTagReference item){
        this.builder = new NamedTagReferenceBuilder(this, item);
        }
    
            public N endTag(){
            return and();
        }
            public N and(){
            return (N) ImageStreamSpecFluent.this.addToTags(builder.build());
        }
    
}


}
