package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class OAuthAccessTokenListFluent<T extends OAuthAccessTokenListFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     OAuthAccessTokenList.ApiVersion apiVersion;     List<VisitableBuilder<OAuthAccessToken, ?>> items = new ArrayList();     String kind;     VisitableBuilder<ListMeta, ?> metadata;     Map<String, Object> additionalProperties = new HashMap();

    public OAuthAccessTokenList.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( OAuthAccessTokenList.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToItems( OAuthAccessToken item){
    if (item != null) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.add(builder);this.items.add(builder);} return (T)this;
    }
    public List<OAuthAccessToken> getItems(){
    return build(items);
    }
    public T withItems( List<OAuthAccessToken> items){
    this.items.clear();if (items != null) {for (OAuthAccessToken item : items){this.addToItems(item);}} return (T) this;
    }
    public ItemsNested<T> addNewItem(){
    return new ItemsNested<T>();
    }
    public ItemsNested<T> addNewItemLike( OAuthAccessToken item){
    return new ItemsNested<T>(item);
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ListMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ListMeta metadata){
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ListMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T withNewMetadata( String resourceVersion,  String selfLink){
    return withMetadata(new ListMeta(resourceVersion, selfLink));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class ItemsNested<N> extends OAuthAccessTokenFluent<ItemsNested<N>> implements Nested<N>{

        private final OAuthAccessTokenBuilder builder;
    
             ItemsNested (){
        this.builder = new OAuthAccessTokenBuilder(this);
        }
             ItemsNested ( OAuthAccessToken item){
        this.builder = new OAuthAccessTokenBuilder(this, item);
        }
    
            public N endItem(){
            return and();
        }
            public N and(){
            return (N) OAuthAccessTokenListFluent.this.addToItems(builder.build());
        }
    
}
    public class MetadataNested<N> extends ListMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ListMetaBuilder builder;
    
             MetadataNested ( ListMeta item){
        this.builder = new ListMetaBuilder(this, item);
        }
             MetadataNested (){
        this.builder = new ListMetaBuilder(this);
        }
    
            public N endMetadata(){
            return and();
        }
            public N and(){
            return (N) OAuthAccessTokenListFluent.this.withMetadata(builder.build());
        }
    
}


}
