package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class WebHookTriggerBuilder extends WebHookTriggerFluent<WebHookTriggerBuilder> implements VisitableBuilder<WebHookTrigger,WebHookTriggerBuilder>{

     WebHookTriggerFluent<?> fluent;
public WebHookTriggerBuilder(){
    this(new WebHookTrigger());
}
public WebHookTriggerBuilder( WebHookTriggerFluent<?> fluent ){
    this(fluent, new WebHookTrigger());
}
public WebHookTriggerBuilder( WebHookTriggerFluent<?> fluent , WebHookTrigger instance ){
    this.fluent = fluent; fluent.withSecret(instance.getSecret()); 
}
public WebHookTriggerBuilder( WebHookTrigger instance ){
    this.fluent = this; this.withSecret(instance.getSecret()); 
}

public EditableWebHookTrigger build(){
    EditableWebHookTrigger buildable = new EditableWebHookTrigger(fluent.getSecret());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    