
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "fieldPath"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class ObjectFieldSelector {

    /**
     * version of the schema that fieldPath is written in terms of; defaults to v1
     * 
     */
    @JsonProperty("apiVersion")
    private String apiVersion;
    /**
     * path of the field to select in the specified API version
     * 
     */
    @JsonProperty("fieldPath")
    private String fieldPath;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ObjectFieldSelector() {
    }

    /**
     * 
     * @param apiVersion
     * @param fieldPath
     */
    public ObjectFieldSelector(String apiVersion, String fieldPath) {
        this.apiVersion = apiVersion;
        this.fieldPath = fieldPath;
    }

    /**
     * version of the schema that fieldPath is written in terms of; defaults to v1
     * 
     * @return
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public String getApiVersion() {
        return apiVersion;
    }

    /**
     * version of the schema that fieldPath is written in terms of; defaults to v1
     * 
     * @param apiVersion
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * path of the field to select in the specified API version
     * 
     * @return
     *     The fieldPath
     */
    @JsonProperty("fieldPath")
    public String getFieldPath() {
        return fieldPath;
    }

    /**
     * path of the field to select in the specified API version
     * 
     * @param fieldPath
     *     The fieldPath
     */
    @JsonProperty("fieldPath")
    public void setFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(apiVersion).append(fieldPath).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ObjectFieldSelector) == false) {
            return false;
        }
        ObjectFieldSelector rhs = ((ObjectFieldSelector) other);
        return new EqualsBuilder().append(apiVersion, rhs.apiVersion).append(fieldPath, rhs.fieldPath).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
