
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "fieldPath",
    "kind",
    "name",
    "namespace",
    "resourceVersion",
    "uid"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class ObjectReference {

    /**
     * API version of the referent
     * 
     */
    @JsonProperty("apiVersion")
    private String apiVersion;
    /**
     * if referring to a piece of an object instead of an entire object
     * 
     */
    @JsonProperty("fieldPath")
    private String fieldPath;
    /**
     * kind of the referent
     * 
     */
    @JsonProperty("kind")
    private String kind;
    /**
     * name of the referent
     * 
     */
    @JsonProperty("name")
    private String name;
    /**
     * namespace of the referent
     * 
     */
    @JsonProperty("namespace")
    private String namespace;
    /**
     * specific resourceVersion to which this reference is made
     * 
     */
    @JsonProperty("resourceVersion")
    private String resourceVersion;
    /**
     * uid of the referent
     * 
     */
    @JsonProperty("uid")
    private String uid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ObjectReference() {
    }

    /**
     * 
     * @param uid
     * @param apiVersion
     * @param resourceVersion
     * @param name
     * @param fieldPath
     * @param kind
     * @param namespace
     */
    public ObjectReference(String apiVersion, String fieldPath, String kind, String name, String namespace, String resourceVersion, String uid) {
        this.apiVersion = apiVersion;
        this.fieldPath = fieldPath;
        this.kind = kind;
        this.name = name;
        this.namespace = namespace;
        this.resourceVersion = resourceVersion;
        this.uid = uid;
    }

    /**
     * API version of the referent
     * 
     * @return
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public String getApiVersion() {
        return apiVersion;
    }

    /**
     * API version of the referent
     * 
     * @param apiVersion
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * if referring to a piece of an object instead of an entire object
     * 
     * @return
     *     The fieldPath
     */
    @JsonProperty("fieldPath")
    public String getFieldPath() {
        return fieldPath;
    }

    /**
     * if referring to a piece of an object instead of an entire object
     * 
     * @param fieldPath
     *     The fieldPath
     */
    @JsonProperty("fieldPath")
    public void setFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
    }

    /**
     * kind of the referent
     * 
     * @return
     *     The kind
     */
    @JsonProperty("kind")
    public String getKind() {
        return kind;
    }

    /**
     * kind of the referent
     * 
     * @param kind
     *     The kind
     */
    @JsonProperty("kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    /**
     * name of the referent
     * 
     * @return
     *     The name
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * name of the referent
     * 
     * @param name
     *     The name
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * namespace of the referent
     * 
     * @return
     *     The namespace
     */
    @JsonProperty("namespace")
    public String getNamespace() {
        return namespace;
    }

    /**
     * namespace of the referent
     * 
     * @param namespace
     *     The namespace
     */
    @JsonProperty("namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    /**
     * specific resourceVersion to which this reference is made
     * 
     * @return
     *     The resourceVersion
     */
    @JsonProperty("resourceVersion")
    public String getResourceVersion() {
        return resourceVersion;
    }

    /**
     * specific resourceVersion to which this reference is made
     * 
     * @param resourceVersion
     *     The resourceVersion
     */
    @JsonProperty("resourceVersion")
    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    /**
     * uid of the referent
     * 
     * @return
     *     The uid
     */
    @JsonProperty("uid")
    public String getUid() {
        return uid;
    }

    /**
     * uid of the referent
     * 
     * @param uid
     *     The uid
     */
    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(apiVersion).append(fieldPath).append(kind).append(name).append(namespace).append(resourceVersion).append(uid).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ObjectReference) == false) {
            return false;
        }
        ObjectReference rhs = ((ObjectReference) other);
        return new EqualsBuilder().append(apiVersion, rhs.apiVersion).append(fieldPath, rhs.fieldPath).append(kind, rhs.kind).append(name, rhs.name).append(namespace, rhs.namespace).append(resourceVersion, rhs.resourceVersion).append(uid, rhs.uid).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
