
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "causes",
    "kind",
    "name",
    "retryAfterSeconds"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class StatusDetails {

    /**
     * the Causes array includes more details associated with the StatusReason failure; not all StatusReasons may provide detailed causes
     * 
     */
    @JsonProperty("causes")
    @Valid
    private List<StatusCause> causes = new ArrayList<StatusCause>();
    /**
     * the kind attribute of the resource associated with the status StatusReason; on some operations may differ from the requested resource Kind
     * 
     */
    @JsonProperty("kind")
    private String kind;
    /**
     * the name attribute of the resource associated with the status StatusReason (when there is a single name which can be described)
     * 
     */
    @JsonProperty("name")
    private String name;
    /**
     * the number of seconds before the client should attempt to retry this operation
     * 
     */
    @JsonProperty("retryAfterSeconds")
    private Integer retryAfterSeconds;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public StatusDetails() {
    }

    /**
     * 
     * @param retryAfterSeconds
     * @param name
     * @param causes
     * @param kind
     */
    public StatusDetails(List<StatusCause> causes, String kind, String name, Integer retryAfterSeconds) {
        this.causes = causes;
        this.kind = kind;
        this.name = name;
        this.retryAfterSeconds = retryAfterSeconds;
    }

    /**
     * the Causes array includes more details associated with the StatusReason failure; not all StatusReasons may provide detailed causes
     * 
     * @return
     *     The causes
     */
    @JsonProperty("causes")
    public List<StatusCause> getCauses() {
        return causes;
    }

    /**
     * the Causes array includes more details associated with the StatusReason failure; not all StatusReasons may provide detailed causes
     * 
     * @param causes
     *     The causes
     */
    @JsonProperty("causes")
    public void setCauses(List<StatusCause> causes) {
        this.causes = causes;
    }

    /**
     * the kind attribute of the resource associated with the status StatusReason; on some operations may differ from the requested resource Kind
     * 
     * @return
     *     The kind
     */
    @JsonProperty("kind")
    public String getKind() {
        return kind;
    }

    /**
     * the kind attribute of the resource associated with the status StatusReason; on some operations may differ from the requested resource Kind
     * 
     * @param kind
     *     The kind
     */
    @JsonProperty("kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    /**
     * the name attribute of the resource associated with the status StatusReason (when there is a single name which can be described)
     * 
     * @return
     *     The name
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * the name attribute of the resource associated with the status StatusReason (when there is a single name which can be described)
     * 
     * @param name
     *     The name
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * the number of seconds before the client should attempt to retry this operation
     * 
     * @return
     *     The retryAfterSeconds
     */
    @JsonProperty("retryAfterSeconds")
    public Integer getRetryAfterSeconds() {
        return retryAfterSeconds;
    }

    /**
     * the number of seconds before the client should attempt to retry this operation
     * 
     * @param retryAfterSeconds
     *     The retryAfterSeconds
     */
    @JsonProperty("retryAfterSeconds")
    public void setRetryAfterSeconds(Integer retryAfterSeconds) {
        this.retryAfterSeconds = retryAfterSeconds;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(causes).append(kind).append(name).append(retryAfterSeconds).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof StatusDetails) == false) {
            return false;
        }
        StatusDetails rhs = ((StatusDetails) other);
        return new EqualsBuilder().append(causes, rhs.causes).append(kind, rhs.kind).append(name, rhs.name).append(retryAfterSeconds, rhs.retryAfterSeconds).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
