package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class BuildSourceFluent<T extends BuildSourceFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String contextDir;     VisitableBuilder<GitBuildSource, ?> git;     LocalObjectReference sourceSecret;     String type;     Map<String, Object> additionalProperties = new HashMap();

    public String getContextDir(){
    return this.contextDir;
    }
    public T withContextDir( String contextDir){
    this.contextDir=contextDir; return (T) this;
    }
    public GitBuildSource getGit(){
    return this.git!=null?this.git.build():null;
    }
    public T withGit( GitBuildSource git){
    if (git!=null){ this.git= new GitBuildSourceBuilder(git); _visitables.add(this.git);} return (T) this;
    }
    public GitNested<T> withNewGit(){
    return new GitNested<T>();
    }
    public GitNested<T> withNewGitLike( GitBuildSource item){
    return new GitNested<T>(item);
    }
    public GitNested<T> editGit(){
    return withNewGitLike(getGit());
    }
    public T withNewGit( String httpProxy,  String httpsProxy,  String ref,  String uri){
    return withGit(new GitBuildSource(httpProxy, httpsProxy, ref, uri));
    }
    public LocalObjectReference getSourceSecret(){
    return this.sourceSecret;
    }
    public T withSourceSecret( LocalObjectReference sourceSecret){
    this.sourceSecret=sourceSecret; return (T) this;
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class GitNested<N> extends GitBuildSourceFluent<GitNested<N>> implements Nested<N>{

        private final GitBuildSourceBuilder builder;
    
             GitNested ( GitBuildSource item){
        this.builder = new GitBuildSourceBuilder(this, item);
        }
             GitNested (){
        this.builder = new GitBuildSourceBuilder(this);
        }
    
            public N and(){
            return (N) BuildSourceFluent.this.withGit(builder.build());
        }
            public N endGit(){
            return and();
        }
    
}


}
