
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "caCertificate",
    "certificate",
    "destinationCACertificate",
    "key",
    "termination"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class TLSConfig {

    /**
     * provides the cert authority certificate contents
     * 
     */
    @JsonProperty("caCertificate")
    private String caCertificate;
    /**
     * provides certificate contents
     * 
     */
    @JsonProperty("certificate")
    private String certificate;
    /**
     * provides the contents of the ca certificate of the final destination.  When using re-encrypt termination this file should be provided in order to have routers use it for health checks on the secure connection
     * 
     */
    @JsonProperty("destinationCACertificate")
    private String destinationCACertificate;
    /**
     * provides key file contents
     * 
     */
    @JsonProperty("key")
    private String key;
    /**
     * indicates termination type.  if not set
     * 
     */
    @JsonProperty("termination")
    private String termination;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public TLSConfig() {
    }

    /**
     * 
     * @param termination
     * @param caCertificate
     * @param certificate
     * @param key
     * @param destinationCACertificate
     */
    public TLSConfig(String caCertificate, String certificate, String destinationCACertificate, String key, String termination) {
        this.caCertificate = caCertificate;
        this.certificate = certificate;
        this.destinationCACertificate = destinationCACertificate;
        this.key = key;
        this.termination = termination;
    }

    /**
     * provides the cert authority certificate contents
     * 
     * @return
     *     The caCertificate
     */
    @JsonProperty("caCertificate")
    public String getCaCertificate() {
        return caCertificate;
    }

    /**
     * provides the cert authority certificate contents
     * 
     * @param caCertificate
     *     The caCertificate
     */
    @JsonProperty("caCertificate")
    public void setCaCertificate(String caCertificate) {
        this.caCertificate = caCertificate;
    }

    /**
     * provides certificate contents
     * 
     * @return
     *     The certificate
     */
    @JsonProperty("certificate")
    public String getCertificate() {
        return certificate;
    }

    /**
     * provides certificate contents
     * 
     * @param certificate
     *     The certificate
     */
    @JsonProperty("certificate")
    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    /**
     * provides the contents of the ca certificate of the final destination.  When using re-encrypt termination this file should be provided in order to have routers use it for health checks on the secure connection
     * 
     * @return
     *     The destinationCACertificate
     */
    @JsonProperty("destinationCACertificate")
    public String getDestinationCACertificate() {
        return destinationCACertificate;
    }

    /**
     * provides the contents of the ca certificate of the final destination.  When using re-encrypt termination this file should be provided in order to have routers use it for health checks on the secure connection
     * 
     * @param destinationCACertificate
     *     The destinationCACertificate
     */
    @JsonProperty("destinationCACertificate")
    public void setDestinationCACertificate(String destinationCACertificate) {
        this.destinationCACertificate = destinationCACertificate;
    }

    /**
     * provides key file contents
     * 
     * @return
     *     The key
     */
    @JsonProperty("key")
    public String getKey() {
        return key;
    }

    /**
     * provides key file contents
     * 
     * @param key
     *     The key
     */
    @JsonProperty("key")
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * indicates termination type.  if not set
     * 
     * @return
     *     The termination
     */
    @JsonProperty("termination")
    public String getTermination() {
        return termination;
    }

    /**
     * indicates termination type.  if not set
     * 
     * @param termination
     *     The termination
     */
    @JsonProperty("termination")
    public void setTermination(String termination) {
        this.termination = termination;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(caCertificate).append(certificate).append(destinationCACertificate).append(key).append(termination).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TLSConfig) == false) {
            return false;
        }
        TLSConfig rhs = ((TLSConfig) other);
        return new EqualsBuilder().append(caCertificate, rhs.caCertificate).append(certificate, rhs.certificate).append(destinationCACertificate, rhs.destinationCACertificate).append(key, rhs.key).append(termination, rhs.termination).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
