package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class VolumeBuilder extends VolumeFluent<VolumeBuilder> implements VisitableBuilder<Volume,VolumeBuilder>{

     VolumeFluent<?> fluent;
public VolumeBuilder(){
    this(new Volume());
}
public VolumeBuilder( VolumeFluent<?> fluent ){
    this(fluent, new Volume());
}
public VolumeBuilder( VolumeFluent<?> fluent , Volume instance ){
    this.fluent = fluent; fluent.withAwsElasticBlockStore(instance.getAwsElasticBlockStore()); fluent.withEmptyDir(instance.getEmptyDir()); fluent.withGcePersistentDisk(instance.getGcePersistentDisk()); fluent.withGitRepo(instance.getGitRepo()); fluent.withGlusterfs(instance.getGlusterfs()); fluent.withHostPath(instance.getHostPath()); fluent.withIscsi(instance.getIscsi()); fluent.withName(instance.getName()); fluent.withNfs(instance.getNfs()); fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); fluent.withRbd(instance.getRbd()); fluent.withSecret(instance.getSecret()); 
}
public VolumeBuilder( Volume instance ){
    this.fluent = this; this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore()); this.withEmptyDir(instance.getEmptyDir()); this.withGcePersistentDisk(instance.getGcePersistentDisk()); this.withGitRepo(instance.getGitRepo()); this.withGlusterfs(instance.getGlusterfs()); this.withHostPath(instance.getHostPath()); this.withIscsi(instance.getIscsi()); this.withName(instance.getName()); this.withNfs(instance.getNfs()); this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); this.withRbd(instance.getRbd()); this.withSecret(instance.getSecret()); 
}

public EditableVolume build(){
    EditableVolume buildable = new EditableVolume(fluent.getAwsElasticBlockStore(),fluent.getEmptyDir(),fluent.getGcePersistentDisk(),fluent.getGitRepo(),fluent.getGlusterfs(),fluent.getHostPath(),fluent.getIscsi(),fluent.getName(),fluent.getNfs(),fluent.getPersistentVolumeClaim(),fluent.getRbd(),fluent.getSecret());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    