
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "exec",
    "httpGet",
    "initialDelaySeconds",
    "tcpSocket",
    "timeoutSeconds"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class Probe {

    /**
     * 
     * 
     */
    @JsonProperty("exec")
    @Valid
    private ExecAction exec;
    /**
     * 
     * 
     */
    @JsonProperty("httpGet")
    @Valid
    private HTTPGetAction httpGet;
    /**
     * number of seconds after the container has started before liveness probes are initiated
     * 
     */
    @JsonProperty("initialDelaySeconds")
    private Long initialDelaySeconds;
    /**
     * 
     * 
     */
    @JsonProperty("tcpSocket")
    @Valid
    private TCPSocketAction tcpSocket;
    /**
     * number of seconds after which liveness probes timeout; defaults to 1 second
     * 
     */
    @JsonProperty("timeoutSeconds")
    private Long timeoutSeconds;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public Probe() {
    }

    /**
     * 
     * @param timeoutSeconds
     * @param initialDelaySeconds
     * @param httpGet
     * @param exec
     * @param tcpSocket
     */
    public Probe(ExecAction exec, HTTPGetAction httpGet, Long initialDelaySeconds, TCPSocketAction tcpSocket, Long timeoutSeconds) {
        this.exec = exec;
        this.httpGet = httpGet;
        this.initialDelaySeconds = initialDelaySeconds;
        this.tcpSocket = tcpSocket;
        this.timeoutSeconds = timeoutSeconds;
    }

    /**
     * 
     * 
     * @return
     *     The exec
     */
    @JsonProperty("exec")
    public ExecAction getExec() {
        return exec;
    }

    /**
     * 
     * 
     * @param exec
     *     The exec
     */
    @JsonProperty("exec")
    public void setExec(ExecAction exec) {
        this.exec = exec;
    }

    /**
     * 
     * 
     * @return
     *     The httpGet
     */
    @JsonProperty("httpGet")
    public HTTPGetAction getHttpGet() {
        return httpGet;
    }

    /**
     * 
     * 
     * @param httpGet
     *     The httpGet
     */
    @JsonProperty("httpGet")
    public void setHttpGet(HTTPGetAction httpGet) {
        this.httpGet = httpGet;
    }

    /**
     * number of seconds after the container has started before liveness probes are initiated
     * 
     * @return
     *     The initialDelaySeconds
     */
    @JsonProperty("initialDelaySeconds")
    public Long getInitialDelaySeconds() {
        return initialDelaySeconds;
    }

    /**
     * number of seconds after the container has started before liveness probes are initiated
     * 
     * @param initialDelaySeconds
     *     The initialDelaySeconds
     */
    @JsonProperty("initialDelaySeconds")
    public void setInitialDelaySeconds(Long initialDelaySeconds) {
        this.initialDelaySeconds = initialDelaySeconds;
    }

    /**
     * 
     * 
     * @return
     *     The tcpSocket
     */
    @JsonProperty("tcpSocket")
    public TCPSocketAction getTcpSocket() {
        return tcpSocket;
    }

    /**
     * 
     * 
     * @param tcpSocket
     *     The tcpSocket
     */
    @JsonProperty("tcpSocket")
    public void setTcpSocket(TCPSocketAction tcpSocket) {
        this.tcpSocket = tcpSocket;
    }

    /**
     * number of seconds after which liveness probes timeout; defaults to 1 second
     * 
     * @return
     *     The timeoutSeconds
     */
    @JsonProperty("timeoutSeconds")
    public Long getTimeoutSeconds() {
        return timeoutSeconds;
    }

    /**
     * number of seconds after which liveness probes timeout; defaults to 1 second
     * 
     * @param timeoutSeconds
     *     The timeoutSeconds
     */
    @JsonProperty("timeoutSeconds")
    public void setTimeoutSeconds(Long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(exec).append(httpGet).append(initialDelaySeconds).append(tcpSocket).append(timeoutSeconds).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Probe) == false) {
            return false;
        }
        Probe rhs = ((Probe) other);
        return new EqualsBuilder().append(exec, rhs.exec).append(httpGet, rhs.httpGet).append(initialDelaySeconds, rhs.initialDelaySeconds).append(tcpSocket, rhs.tcpSocket).append(timeoutSeconds, rhs.timeoutSeconds).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
