
package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReference;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "env",
    "forcePull",
    "from",
    "noCache",
    "pullSecret"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class DockerBuildStrategy {

    /**
     * additional environment variables you want to pass into a builder container
     * 
     */
    @JsonProperty("env")
    @Valid
    private List<EnvVar> env = new ArrayList<EnvVar>();
    /**
     * forces the source build to pull the image if true
     * 
     */
    @JsonProperty("forcePull")
    private Boolean forcePull;
    /**
     * 
     * 
     */
    @JsonProperty("from")
    @Valid
    private ObjectReference from;
    /**
     * if true
     * 
     */
    @JsonProperty("noCache")
    private Boolean noCache;
    /**
     * 
     * 
     */
    @JsonProperty("pullSecret")
    @Valid
    private LocalObjectReference pullSecret;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public DockerBuildStrategy() {
    }

    /**
     * 
     * @param noCache
     * @param forcePull
     * @param from
     * @param env
     * @param pullSecret
     */
    public DockerBuildStrategy(List<EnvVar> env, Boolean forcePull, ObjectReference from, Boolean noCache, LocalObjectReference pullSecret) {
        this.env = env;
        this.forcePull = forcePull;
        this.from = from;
        this.noCache = noCache;
        this.pullSecret = pullSecret;
    }

    /**
     * additional environment variables you want to pass into a builder container
     * 
     * @return
     *     The env
     */
    @JsonProperty("env")
    public List<EnvVar> getEnv() {
        return env;
    }

    /**
     * additional environment variables you want to pass into a builder container
     * 
     * @param env
     *     The env
     */
    @JsonProperty("env")
    public void setEnv(List<EnvVar> env) {
        this.env = env;
    }

    /**
     * forces the source build to pull the image if true
     * 
     * @return
     *     The forcePull
     */
    @JsonProperty("forcePull")
    public Boolean getForcePull() {
        return forcePull;
    }

    /**
     * forces the source build to pull the image if true
     * 
     * @param forcePull
     *     The forcePull
     */
    @JsonProperty("forcePull")
    public void setForcePull(Boolean forcePull) {
        this.forcePull = forcePull;
    }

    /**
     * 
     * 
     * @return
     *     The from
     */
    @JsonProperty("from")
    public ObjectReference getFrom() {
        return from;
    }

    /**
     * 
     * 
     * @param from
     *     The from
     */
    @JsonProperty("from")
    public void setFrom(ObjectReference from) {
        this.from = from;
    }

    /**
     * if true
     * 
     * @return
     *     The noCache
     */
    @JsonProperty("noCache")
    public Boolean getNoCache() {
        return noCache;
    }

    /**
     * if true
     * 
     * @param noCache
     *     The noCache
     */
    @JsonProperty("noCache")
    public void setNoCache(Boolean noCache) {
        this.noCache = noCache;
    }

    /**
     * 
     * 
     * @return
     *     The pullSecret
     */
    @JsonProperty("pullSecret")
    public LocalObjectReference getPullSecret() {
        return pullSecret;
    }

    /**
     * 
     * 
     * @param pullSecret
     *     The pullSecret
     */
    @JsonProperty("pullSecret")
    public void setPullSecret(LocalObjectReference pullSecret) {
        this.pullSecret = pullSecret;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(env).append(forcePull).append(from).append(noCache).append(pullSecret).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DockerBuildStrategy) == false) {
            return false;
        }
        DockerBuildStrategy rhs = ((DockerBuildStrategy) other);
        return new EqualsBuilder().append(env, rhs.env).append(forcePull, rhs.forcePull).append(from, rhs.from).append(noCache, rhs.noCache).append(pullSecret, rhs.pullSecret).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
