/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventBuilder;
import io.fabric8.kubernetes.api.model.EventFluent;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventListFluent<T extends EventListFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    EventList.ApiVersion apiVersion;
    List<VisitableBuilder<Event, ?>> items = new ArrayList();
    String kind;
    VisitableBuilder<ListMeta, ?> metadata;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public EventList.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(EventList.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public T addToItems(Event ... items) {
        for (Event item : items) {
            EventBuilder builder = new EventBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (T)this;
    }

    public List<Event> getItems() {
        return this.build(this.items);
    }

    public T withItems(List<Event> items) {
        this.items.clear();
        if (items != null) {
            for (Event item : items) {
                this.addToItems(item);
            }
        }
        return (T)this;
    }

    public T withItems(Event ... items) {
        this.items.clear();
        if (items != null) {
            for (Event item : items) {
                this.addToItems(item);
            }
        }
        return (T)this;
    }

    public ItemsNested<T> addNewItem() {
        return new ItemsNested();
    }

    public ItemsNested<T> addNewItemLike(Event item) {
        return new ItemsNested(item);
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    public T withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ListMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public T withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class MetadataNested<N>
    extends ListMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNested() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNested(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        public N endMetadata() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)EventListFluent.this.withMetadata(this.builder.build());
        }
    }

    public class ItemsNested<N>
    extends EventFluent<ItemsNested<N>>
    implements Nested<N> {
        private final EventBuilder builder;

        ItemsNested(Event item) {
            this.builder = new EventBuilder(this, item);
        }

        ItemsNested() {
            this.builder = new EventBuilder(this);
        }

        public N endItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)EventListFluent.this.addToItems(this.builder.build());
        }
    }
}

