package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class BuildOutputBuilder extends BuildOutputFluent<BuildOutputBuilder> implements VisitableBuilder<BuildOutput,BuildOutputBuilder>{

     BuildOutputFluent<?> fluent;
public BuildOutputBuilder(){
    this(new BuildOutput());
}
public BuildOutputBuilder( BuildOutputFluent<?> fluent ){
    this(fluent, new BuildOutput());
}
public BuildOutputBuilder( BuildOutputFluent<?> fluent , BuildOutput instance ){
    this.fluent = fluent; fluent.withPushSecret(instance.getPushSecret()); fluent.withTo(instance.getTo()); 
}
public BuildOutputBuilder( BuildOutput instance ){
    this.fluent = this; this.withPushSecret(instance.getPushSecret()); this.withTo(instance.getTo()); 
}

public EditableBuildOutput build(){
    EditableBuildOutput buildable = new EditableBuildOutput(fluent.getPushSecret(),fluent.getTo());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    