package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class DeploymentDetailsBuilder extends DeploymentDetailsFluent<DeploymentDetailsBuilder> implements VisitableBuilder<DeploymentDetails,DeploymentDetailsBuilder>{

     DeploymentDetailsFluent<?> fluent;
public DeploymentDetailsBuilder(){
    this(new DeploymentDetails());
}
public DeploymentDetailsBuilder( DeploymentDetailsFluent<?> fluent ){
    this(fluent, new DeploymentDetails());
}
public DeploymentDetailsBuilder( DeploymentDetailsFluent<?> fluent , DeploymentDetails instance ){
    this.fluent = fluent; fluent.withCauses(instance.getCauses()); fluent.withMessage(instance.getMessage()); 
}
public DeploymentDetailsBuilder( DeploymentDetails instance ){
    this.fluent = this; this.withCauses(instance.getCauses()); this.withMessage(instance.getMessage()); 
}

public EditableDeploymentDetails build(){
    EditableDeploymentDetails buildable = new EditableDeploymentDetails(fluent.getCauses(),fluent.getMessage());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    