package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class BuildStrategyFluent<T extends BuildStrategyFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<CustomBuildStrategy, ?> customStrategy;     VisitableBuilder<DockerBuildStrategy, ?> dockerStrategy;     VisitableBuilder<SourceBuildStrategy, ?> sourceStrategy;     String type;     Map<String, Object> additionalProperties = new HashMap();

    public CustomBuildStrategy getCustomStrategy(){
    return this.customStrategy!=null?this.customStrategy.build():null;
    }
    public T withCustomStrategy( CustomBuildStrategy customStrategy){
    if (customStrategy!=null){ this.customStrategy= new CustomBuildStrategyBuilder(customStrategy); _visitables.add(this.customStrategy);} return (T) this;
    }
    public CustomStrategyNested<T> withNewCustomStrategy(){
    return new CustomStrategyNested<T>();
    }
    public CustomStrategyNested<T> withNewCustomStrategyLike( CustomBuildStrategy item){
    return new CustomStrategyNested<T>(item);
    }
    public CustomStrategyNested<T> editCustomStrategy(){
    return withNewCustomStrategyLike(getCustomStrategy());
    }
    public DockerBuildStrategy getDockerStrategy(){
    return this.dockerStrategy!=null?this.dockerStrategy.build():null;
    }
    public T withDockerStrategy( DockerBuildStrategy dockerStrategy){
    if (dockerStrategy!=null){ this.dockerStrategy= new DockerBuildStrategyBuilder(dockerStrategy); _visitables.add(this.dockerStrategy);} return (T) this;
    }
    public DockerStrategyNested<T> withNewDockerStrategy(){
    return new DockerStrategyNested<T>();
    }
    public DockerStrategyNested<T> withNewDockerStrategyLike( DockerBuildStrategy item){
    return new DockerStrategyNested<T>(item);
    }
    public DockerStrategyNested<T> editDockerStrategy(){
    return withNewDockerStrategyLike(getDockerStrategy());
    }
    public SourceBuildStrategy getSourceStrategy(){
    return this.sourceStrategy!=null?this.sourceStrategy.build():null;
    }
    public T withSourceStrategy( SourceBuildStrategy sourceStrategy){
    if (sourceStrategy!=null){ this.sourceStrategy= new SourceBuildStrategyBuilder(sourceStrategy); _visitables.add(this.sourceStrategy);} return (T) this;
    }
    public SourceStrategyNested<T> withNewSourceStrategy(){
    return new SourceStrategyNested<T>();
    }
    public SourceStrategyNested<T> withNewSourceStrategyLike( SourceBuildStrategy item){
    return new SourceStrategyNested<T>(item);
    }
    public SourceStrategyNested<T> editSourceStrategy(){
    return withNewSourceStrategyLike(getSourceStrategy());
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildStrategyFluent that = (BuildStrategyFluent) o;
if (customStrategy != null ? !customStrategy.equals(that.customStrategy) :that.customStrategy != null) return false;
if (dockerStrategy != null ? !dockerStrategy.equals(that.dockerStrategy) :that.dockerStrategy != null) return false;
if (sourceStrategy != null ? !sourceStrategy.equals(that.sourceStrategy) :that.sourceStrategy != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class CustomStrategyNested<N> extends CustomBuildStrategyFluent<CustomStrategyNested<N>> implements Nested<N>{

        private final CustomBuildStrategyBuilder builder;
    
             CustomStrategyNested ( CustomBuildStrategy item){
        this.builder = new CustomBuildStrategyBuilder(this, item);
        }
             CustomStrategyNested (){
        this.builder = new CustomBuildStrategyBuilder(this);
        }
    
            public N endCustomStrategy(){
            return and();
        }
            public N and(){
            return (N) BuildStrategyFluent.this.withCustomStrategy(builder.build());
        }
    
}
    public class DockerStrategyNested<N> extends DockerBuildStrategyFluent<DockerStrategyNested<N>> implements Nested<N>{

        private final DockerBuildStrategyBuilder builder;
    
             DockerStrategyNested (){
        this.builder = new DockerBuildStrategyBuilder(this);
        }
             DockerStrategyNested ( DockerBuildStrategy item){
        this.builder = new DockerBuildStrategyBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildStrategyFluent.this.withDockerStrategy(builder.build());
        }
            public N endDockerStrategy(){
            return and();
        }
    
}
    public class SourceStrategyNested<N> extends SourceBuildStrategyFluent<SourceStrategyNested<N>> implements Nested<N>{

        private final SourceBuildStrategyBuilder builder;
    
             SourceStrategyNested (){
        this.builder = new SourceBuildStrategyBuilder(this);
        }
             SourceStrategyNested ( SourceBuildStrategy item){
        this.builder = new SourceBuildStrategyBuilder(this, item);
        }
    
            public N endSourceStrategy(){
            return and();
        }
            public N and(){
            return (N) BuildStrategyFluent.this.withSourceStrategy(builder.build());
        }
    
}


}
