package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.openshift.api.model.IdentityBuilder;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.api.model.ClusterRoleBindingFluent;
import io.fabric8.openshift.api.model.PolicyBuilder;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.ClusterRoleFluent;
import io.fabric8.openshift.api.model.PolicyBinding;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.openshift.api.model.ClusterRole;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageFluent;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.Policy;
import io.fabric8.openshift.api.model.BuildFluent;
import io.fabric8.openshift.api.model.OAuthClientBuilder;
import io.fabric8.openshift.api.model.IdentityFluent;
import io.fabric8.openshift.api.model.ClusterPolicyFluent;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.PolicyBindingFluent;
import io.fabric8.openshift.api.model.OAuthAccessTokenBuilder;
import io.fabric8.openshift.api.model.GroupBuilder;
import io.fabric8.openshift.api.model.PolicyBindingBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ClusterPolicy;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.BuildRequestBuilder;
import io.fabric8.openshift.api.model.GroupFluent;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.ClusterRoleBuilder;
import io.fabric8.openshift.api.model.PolicyFluent;
import io.fabric8.openshift.api.model.OAuthAccessTokenFluent;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.ClusterPolicyBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluent;
import io.fabric8.openshift.api.model.RoleBindingFluent;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.TemplateFluent;
import io.fabric8.openshift.api.model.UserBuilder;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.ImageBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RoleFluent;
import io.fabric8.openshift.api.model.BuildBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.RoleBindingBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.UserFluent;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.OAuthClientFluent;
import io.fabric8.openshift.api.model.ClusterPolicyBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingBuilder;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyBindingFluent;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.RoleBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyBindingBuilder;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.Identity;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class BaseKubernetesListFluent<T extends BaseKubernetesListFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     BaseKubernetesList.ApiVersion apiVersion;     List<HasMetadata> items = new ArrayList();     List<VisitableBuilder<OAuthAccessToken, ?>> oAuthAccessTokenItems = new ArrayList();     List<VisitableBuilder<RoleBinding, ?>> roleBindingItems = new ArrayList();     List<VisitableBuilder<ReplicationController, ?>> replicationControllerItems = new ArrayList();     List<VisitableBuilder<Event, ?>> eventItems = new ArrayList();     List<VisitableBuilder<Endpoints, ?>> endpointsItems = new ArrayList();     List<VisitableBuilder<Namespace, ?>> namespaceItems = new ArrayList();     List<VisitableBuilder<BuildRequest, ?>> buildRequestItems = new ArrayList();     List<VisitableBuilder<Node, ?>> nodeItems = new ArrayList();     List<VisitableBuilder<DeploymentConfig, ?>> deploymentConfigItems = new ArrayList();     List<VisitableBuilder<ClusterPolicyBinding, ?>> clusterPolicyBindingItems = new ArrayList();     List<VisitableBuilder<OAuthClientAuthorization, ?>> oAuthClientAuthorizationItems = new ArrayList();     List<VisitableBuilder<User, ?>> userItems = new ArrayList();     List<VisitableBuilder<OAuthAuthorizeToken, ?>> oAuthAuthorizeTokenItems = new ArrayList();     List<VisitableBuilder<PersistentVolume, ?>> persistentVolumeItems = new ArrayList();     List<VisitableBuilder<Policy, ?>> policyItems = new ArrayList();     List<VisitableBuilder<SecurityContextConstraints, ?>> securityContextConstraintsItems = new ArrayList();     List<VisitableBuilder<ClusterPolicy, ?>> clusterPolicyItems = new ArrayList();     List<VisitableBuilder<ClusterRole, ?>> clusterRoleItems = new ArrayList();     List<VisitableBuilder<OAuthClient, ?>> oAuthClientItems = new ArrayList();     List<VisitableBuilder<Service, ?>> serviceItems = new ArrayList();     List<VisitableBuilder<Role, ?>> roleItems = new ArrayList();     List<VisitableBuilder<Image, ?>> imageItems = new ArrayList();     List<VisitableBuilder<ClusterRoleBinding, ?>> clusterRoleBindingItems = new ArrayList();     List<VisitableBuilder<Route, ?>> routeItems = new ArrayList();     List<VisitableBuilder<ImageStream, ?>> imageStreamItems = new ArrayList();     List<VisitableBuilder<Template, ?>> templateItems = new ArrayList();     List<VisitableBuilder<BuildConfig, ?>> buildConfigItems = new ArrayList();     List<VisitableBuilder<ServiceAccount, ?>> serviceAccountItems = new ArrayList();     List<VisitableBuilder<Group, ?>> groupItems = new ArrayList();     List<VisitableBuilder<Build, ?>> buildItems = new ArrayList();     List<VisitableBuilder<ResourceQuota, ?>> resourceQuotaItems = new ArrayList();     List<VisitableBuilder<Secret, ?>> secretItems = new ArrayList();     List<VisitableBuilder<Pod, ?>> podItems = new ArrayList();     List<VisitableBuilder<PolicyBinding, ?>> policyBindingItems = new ArrayList();     List<VisitableBuilder<PersistentVolumeClaim, ?>> persistentVolumeClaimItems = new ArrayList();     List<VisitableBuilder<Identity, ?>> identityItems = new ArrayList();     String kind;     VisitableBuilder<ListMeta, ?> metadata;     Map<String, Object> additionalProperties = new HashMap();

    public BaseKubernetesList.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( BaseKubernetesList.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToItems( HasMetadata ...items){
    for (HasMetadata item : items) {if (item instanceof OAuthAccessToken){addToOAuthAccessTokenItems((OAuthAccessToken)item);}
 else if (item instanceof RoleBinding){addToRoleBindingItems((RoleBinding)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof Event){addToEventItems((Event)item);}
 else if (item instanceof Endpoints){addToEndpointsItems((Endpoints)item);}
 else if (item instanceof Namespace){addToNamespaceItems((Namespace)item);}
 else if (item instanceof BuildRequest){addToBuildRequestItems((BuildRequest)item);}
 else if (item instanceof Node){addToNodeItems((Node)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigItems((DeploymentConfig)item);}
 else if (item instanceof ClusterPolicyBinding){addToClusterPolicyBindingItems((ClusterPolicyBinding)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationItems((OAuthClientAuthorization)item);}
 else if (item instanceof User){addToUserItems((User)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenItems((OAuthAuthorizeToken)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof Policy){addToPolicyItems((Policy)item);}
 else if (item instanceof SecurityContextConstraints){addToSecurityContextConstraintsItems((SecurityContextConstraints)item);}
 else if (item instanceof ClusterPolicy){addToClusterPolicyItems((ClusterPolicy)item);}
 else if (item instanceof ClusterRole){addToClusterRoleItems((ClusterRole)item);}
 else if (item instanceof OAuthClient){addToOAuthClientItems((OAuthClient)item);}
 else if (item instanceof Service){addToServiceItems((Service)item);}
 else if (item instanceof Role){addToRoleItems((Role)item);}
 else if (item instanceof Image){addToImageItems((Image)item);}
 else if (item instanceof ClusterRoleBinding){addToClusterRoleBindingItems((ClusterRoleBinding)item);}
 else if (item instanceof Route){addToRouteItems((Route)item);}
 else if (item instanceof ImageStream){addToImageStreamItems((ImageStream)item);}
 else if (item instanceof Template){addToTemplateItems((Template)item);}
 else if (item instanceof BuildConfig){addToBuildConfigItems((BuildConfig)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems((ServiceAccount)item);}
 else if (item instanceof Group){addToGroupItems((Group)item);}
 else if (item instanceof Build){addToBuildItems((Build)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretItems((Secret)item);}
 else if (item instanceof Pod){addToPodItems((Pod)item);}
 else if (item instanceof PolicyBinding){addToPolicyBindingItems((PolicyBinding)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof Identity){addToIdentityItems((Identity)item);}
} return (T)this;
    }
    public T removeFromItems( HasMetadata ...items){
    for (HasMetadata item : items) {if (item instanceof OAuthAccessToken){removeFromOAuthAccessTokenItems((OAuthAccessToken)item);}
 else if (item instanceof RoleBinding){removeFromRoleBindingItems((RoleBinding)item);}
 else if (item instanceof ReplicationController){removeFromReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof Event){removeFromEventItems((Event)item);}
 else if (item instanceof Endpoints){removeFromEndpointsItems((Endpoints)item);}
 else if (item instanceof Namespace){removeFromNamespaceItems((Namespace)item);}
 else if (item instanceof BuildRequest){removeFromBuildRequestItems((BuildRequest)item);}
 else if (item instanceof Node){removeFromNodeItems((Node)item);}
 else if (item instanceof DeploymentConfig){removeFromDeploymentConfigItems((DeploymentConfig)item);}
 else if (item instanceof ClusterPolicyBinding){removeFromClusterPolicyBindingItems((ClusterPolicyBinding)item);}
 else if (item instanceof OAuthClientAuthorization){removeFromOAuthClientAuthorizationItems((OAuthClientAuthorization)item);}
 else if (item instanceof User){removeFromUserItems((User)item);}
 else if (item instanceof OAuthAuthorizeToken){removeFromOAuthAuthorizeTokenItems((OAuthAuthorizeToken)item);}
 else if (item instanceof PersistentVolume){removeFromPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof Policy){removeFromPolicyItems((Policy)item);}
 else if (item instanceof SecurityContextConstraints){removeFromSecurityContextConstraintsItems((SecurityContextConstraints)item);}
 else if (item instanceof ClusterPolicy){removeFromClusterPolicyItems((ClusterPolicy)item);}
 else if (item instanceof ClusterRole){removeFromClusterRoleItems((ClusterRole)item);}
 else if (item instanceof OAuthClient){removeFromOAuthClientItems((OAuthClient)item);}
 else if (item instanceof Service){removeFromServiceItems((Service)item);}
 else if (item instanceof Role){removeFromRoleItems((Role)item);}
 else if (item instanceof Image){removeFromImageItems((Image)item);}
 else if (item instanceof ClusterRoleBinding){removeFromClusterRoleBindingItems((ClusterRoleBinding)item);}
 else if (item instanceof Route){removeFromRouteItems((Route)item);}
 else if (item instanceof ImageStream){removeFromImageStreamItems((ImageStream)item);}
 else if (item instanceof Template){removeFromTemplateItems((Template)item);}
 else if (item instanceof BuildConfig){removeFromBuildConfigItems((BuildConfig)item);}
 else if (item instanceof ServiceAccount){removeFromServiceAccountItems((ServiceAccount)item);}
 else if (item instanceof Group){removeFromGroupItems((Group)item);}
 else if (item instanceof Build){removeFromBuildItems((Build)item);}
 else if (item instanceof ResourceQuota){removeFromResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){removeFromSecretItems((Secret)item);}
 else if (item instanceof Pod){removeFromPodItems((Pod)item);}
 else if (item instanceof PolicyBinding){removeFromPolicyBindingItems((PolicyBinding)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof Identity){removeFromIdentityItems((Identity)item);}
} return (T)this;
    }
    public List<HasMetadata> getItems(){
    return aggregate(build(oAuthAccessTokenItems), build(roleBindingItems), build(replicationControllerItems), build(eventItems), build(endpointsItems), build(namespaceItems), build(buildRequestItems), build(nodeItems), build(deploymentConfigItems), build(clusterPolicyBindingItems), build(oAuthClientAuthorizationItems), build(userItems), build(oAuthAuthorizeTokenItems), build(persistentVolumeItems), build(policyItems), build(securityContextConstraintsItems), build(clusterPolicyItems), build(clusterRoleItems), build(oAuthClientItems), build(serviceItems), build(roleItems), build(imageItems), build(clusterRoleBindingItems), build(routeItems), build(imageStreamItems), build(templateItems), build(buildConfigItems), build(serviceAccountItems), build(groupItems), build(buildItems), build(resourceQuotaItems), build(secretItems), build(podItems), build(policyBindingItems), build(persistentVolumeClaimItems), build(identityItems));
    }
    public T withItems( List<HasMetadata> items){
    this.items.clear();if (items != null) {for (HasMetadata item : items){this.addToItems(item);}} return (T) this;
    }
    public T withItems( HasMetadata ...items){
    this.items.clear(); if (items != null) {for (HasMetadata item :items){ this.addToItems(item);}} return (T) this;
    }
    public T addToOAuthAccessTokenItems( OAuthAccessToken ...items){
    for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.add(builder);this.oAuthAccessTokenItems.add(builder);} return (T)this;
    }
    public T removeFromOAuthAccessTokenItems( OAuthAccessToken ...items){
    for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.remove(builder);this.oAuthAccessTokenItems.remove(builder);} return (T)this;
    }
    public OAuthAccessTokenItemsNested<T> addNewOAuthAccessTokenItem(){
    return new OAuthAccessTokenItemsNested<T>();
    }
    public OAuthAccessTokenItemsNested<T> addNewOAuthAccessTokenItemLike( OAuthAccessToken item){
    return new OAuthAccessTokenItemsNested<T>(item);
    }
    public T addToRoleBindingItems( RoleBinding ...items){
    for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.add(builder);this.roleBindingItems.add(builder);} return (T)this;
    }
    public T removeFromRoleBindingItems( RoleBinding ...items){
    for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.remove(builder);this.roleBindingItems.remove(builder);} return (T)this;
    }
    public RoleBindingItemsNested<T> addNewRoleBindingItem(){
    return new RoleBindingItemsNested<T>();
    }
    public RoleBindingItemsNested<T> addNewRoleBindingItemLike( RoleBinding item){
    return new RoleBindingItemsNested<T>(item);
    }
    public T addToReplicationControllerItems( ReplicationController ...items){
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.add(builder);this.replicationControllerItems.add(builder);} return (T)this;
    }
    public T removeFromReplicationControllerItems( ReplicationController ...items){
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.remove(builder);this.replicationControllerItems.remove(builder);} return (T)this;
    }
    public ReplicationControllerItemsNested<T> addNewReplicationControllerItem(){
    return new ReplicationControllerItemsNested<T>();
    }
    public ReplicationControllerItemsNested<T> addNewReplicationControllerItemLike( ReplicationController item){
    return new ReplicationControllerItemsNested<T>(item);
    }
    public T addToEventItems( Event ...items){
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.add(builder);this.eventItems.add(builder);} return (T)this;
    }
    public T removeFromEventItems( Event ...items){
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.remove(builder);this.eventItems.remove(builder);} return (T)this;
    }
    public EventItemsNested<T> addNewEventItem(){
    return new EventItemsNested<T>();
    }
    public EventItemsNested<T> addNewEventItemLike( Event item){
    return new EventItemsNested<T>(item);
    }
    public T addToEndpointsItems( Endpoints ...items){
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.add(builder);this.endpointsItems.add(builder);} return (T)this;
    }
    public T removeFromEndpointsItems( Endpoints ...items){
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.remove(builder);this.endpointsItems.remove(builder);} return (T)this;
    }
    public EndpointsItemsNested<T> addNewEndpointsItem(){
    return new EndpointsItemsNested<T>();
    }
    public EndpointsItemsNested<T> addNewEndpointsItemLike( Endpoints item){
    return new EndpointsItemsNested<T>(item);
    }
    public T addToNamespaceItems( Namespace ...items){
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.add(builder);this.namespaceItems.add(builder);} return (T)this;
    }
    public T removeFromNamespaceItems( Namespace ...items){
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.remove(builder);this.namespaceItems.remove(builder);} return (T)this;
    }
    public NamespaceItemsNested<T> addNewNamespaceItem(){
    return new NamespaceItemsNested<T>();
    }
    public NamespaceItemsNested<T> addNewNamespaceItemLike( Namespace item){
    return new NamespaceItemsNested<T>(item);
    }
    public T addToBuildRequestItems( BuildRequest ...items){
    for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.add(builder);this.buildRequestItems.add(builder);} return (T)this;
    }
    public T removeFromBuildRequestItems( BuildRequest ...items){
    for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.remove(builder);this.buildRequestItems.remove(builder);} return (T)this;
    }
    public BuildRequestItemsNested<T> addNewBuildRequestItem(){
    return new BuildRequestItemsNested<T>();
    }
    public BuildRequestItemsNested<T> addNewBuildRequestItemLike( BuildRequest item){
    return new BuildRequestItemsNested<T>(item);
    }
    public T addToNodeItems( Node ...items){
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.add(builder);this.nodeItems.add(builder);} return (T)this;
    }
    public T removeFromNodeItems( Node ...items){
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.remove(builder);this.nodeItems.remove(builder);} return (T)this;
    }
    public NodeItemsNested<T> addNewNodeItem(){
    return new NodeItemsNested<T>();
    }
    public NodeItemsNested<T> addNewNodeItemLike( Node item){
    return new NodeItemsNested<T>(item);
    }
    public T addToDeploymentConfigItems( DeploymentConfig ...items){
    for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.add(builder);this.deploymentConfigItems.add(builder);} return (T)this;
    }
    public T removeFromDeploymentConfigItems( DeploymentConfig ...items){
    for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.remove(builder);this.deploymentConfigItems.remove(builder);} return (T)this;
    }
    public DeploymentConfigItemsNested<T> addNewDeploymentConfigItem(){
    return new DeploymentConfigItemsNested<T>();
    }
    public DeploymentConfigItemsNested<T> addNewDeploymentConfigItemLike( DeploymentConfig item){
    return new DeploymentConfigItemsNested<T>(item);
    }
    public T addToClusterPolicyBindingItems( ClusterPolicyBinding ...items){
    for (ClusterPolicyBinding item : items) {ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.add(builder);this.clusterPolicyBindingItems.add(builder);} return (T)this;
    }
    public T removeFromClusterPolicyBindingItems( ClusterPolicyBinding ...items){
    for (ClusterPolicyBinding item : items) {ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.remove(builder);this.clusterPolicyBindingItems.remove(builder);} return (T)this;
    }
    public ClusterPolicyBindingItemsNested<T> addNewClusterPolicyBindingItem(){
    return new ClusterPolicyBindingItemsNested<T>();
    }
    public ClusterPolicyBindingItemsNested<T> addNewClusterPolicyBindingItemLike( ClusterPolicyBinding item){
    return new ClusterPolicyBindingItemsNested<T>(item);
    }
    public T addToOAuthClientAuthorizationItems( OAuthClientAuthorization ...items){
    for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.add(builder);this.oAuthClientAuthorizationItems.add(builder);} return (T)this;
    }
    public T removeFromOAuthClientAuthorizationItems( OAuthClientAuthorization ...items){
    for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.remove(builder);this.oAuthClientAuthorizationItems.remove(builder);} return (T)this;
    }
    public OAuthClientAuthorizationItemsNested<T> addNewOAuthClientAuthorizationItem(){
    return new OAuthClientAuthorizationItemsNested<T>();
    }
    public OAuthClientAuthorizationItemsNested<T> addNewOAuthClientAuthorizationItemLike( OAuthClientAuthorization item){
    return new OAuthClientAuthorizationItemsNested<T>(item);
    }
    public T addToUserItems( User ...items){
    for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.add(builder);this.userItems.add(builder);} return (T)this;
    }
    public T removeFromUserItems( User ...items){
    for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.remove(builder);this.userItems.remove(builder);} return (T)this;
    }
    public UserItemsNested<T> addNewUserItem(){
    return new UserItemsNested<T>();
    }
    public UserItemsNested<T> addNewUserItemLike( User item){
    return new UserItemsNested<T>(item);
    }
    public T addToOAuthAuthorizeTokenItems( OAuthAuthorizeToken ...items){
    for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.add(builder);this.oAuthAuthorizeTokenItems.add(builder);} return (T)this;
    }
    public T removeFromOAuthAuthorizeTokenItems( OAuthAuthorizeToken ...items){
    for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.remove(builder);this.oAuthAuthorizeTokenItems.remove(builder);} return (T)this;
    }
    public OAuthAuthorizeTokenItemsNested<T> addNewOAuthAuthorizeTokenItem(){
    return new OAuthAuthorizeTokenItemsNested<T>();
    }
    public OAuthAuthorizeTokenItemsNested<T> addNewOAuthAuthorizeTokenItemLike( OAuthAuthorizeToken item){
    return new OAuthAuthorizeTokenItemsNested<T>(item);
    }
    public T addToPersistentVolumeItems( PersistentVolume ...items){
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.add(builder);this.persistentVolumeItems.add(builder);} return (T)this;
    }
    public T removeFromPersistentVolumeItems( PersistentVolume ...items){
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.remove(builder);this.persistentVolumeItems.remove(builder);} return (T)this;
    }
    public PersistentVolumeItemsNested<T> addNewPersistentVolumeItem(){
    return new PersistentVolumeItemsNested<T>();
    }
    public PersistentVolumeItemsNested<T> addNewPersistentVolumeItemLike( PersistentVolume item){
    return new PersistentVolumeItemsNested<T>(item);
    }
    public T addToPolicyItems( Policy ...items){
    for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.add(builder);this.policyItems.add(builder);} return (T)this;
    }
    public T removeFromPolicyItems( Policy ...items){
    for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.remove(builder);this.policyItems.remove(builder);} return (T)this;
    }
    public PolicyItemsNested<T> addNewPolicyItem(){
    return new PolicyItemsNested<T>();
    }
    public PolicyItemsNested<T> addNewPolicyItemLike( Policy item){
    return new PolicyItemsNested<T>(item);
    }
    public T addToSecurityContextConstraintsItems( SecurityContextConstraints ...items){
    for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.add(builder);this.securityContextConstraintsItems.add(builder);} return (T)this;
    }
    public T removeFromSecurityContextConstraintsItems( SecurityContextConstraints ...items){
    for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.remove(builder);this.securityContextConstraintsItems.remove(builder);} return (T)this;
    }
    public SecurityContextConstraintsItemsNested<T> addNewSecurityContextConstraintsItem(){
    return new SecurityContextConstraintsItemsNested<T>();
    }
    public SecurityContextConstraintsItemsNested<T> addNewSecurityContextConstraintsItemLike( SecurityContextConstraints item){
    return new SecurityContextConstraintsItemsNested<T>(item);
    }
    public T addToClusterPolicyItems( ClusterPolicy ...items){
    for (ClusterPolicy item : items) {ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.add(builder);this.clusterPolicyItems.add(builder);} return (T)this;
    }
    public T removeFromClusterPolicyItems( ClusterPolicy ...items){
    for (ClusterPolicy item : items) {ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.remove(builder);this.clusterPolicyItems.remove(builder);} return (T)this;
    }
    public ClusterPolicyItemsNested<T> addNewClusterPolicyItem(){
    return new ClusterPolicyItemsNested<T>();
    }
    public ClusterPolicyItemsNested<T> addNewClusterPolicyItemLike( ClusterPolicy item){
    return new ClusterPolicyItemsNested<T>(item);
    }
    public T addToClusterRoleItems( ClusterRole ...items){
    for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.add(builder);this.clusterRoleItems.add(builder);} return (T)this;
    }
    public T removeFromClusterRoleItems( ClusterRole ...items){
    for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.remove(builder);this.clusterRoleItems.remove(builder);} return (T)this;
    }
    public ClusterRoleItemsNested<T> addNewClusterRoleItem(){
    return new ClusterRoleItemsNested<T>();
    }
    public ClusterRoleItemsNested<T> addNewClusterRoleItemLike( ClusterRole item){
    return new ClusterRoleItemsNested<T>(item);
    }
    public T addToOAuthClientItems( OAuthClient ...items){
    for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.add(builder);this.oAuthClientItems.add(builder);} return (T)this;
    }
    public T removeFromOAuthClientItems( OAuthClient ...items){
    for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.remove(builder);this.oAuthClientItems.remove(builder);} return (T)this;
    }
    public OAuthClientItemsNested<T> addNewOAuthClientItem(){
    return new OAuthClientItemsNested<T>();
    }
    public OAuthClientItemsNested<T> addNewOAuthClientItemLike( OAuthClient item){
    return new OAuthClientItemsNested<T>(item);
    }
    public T addToServiceItems( Service ...items){
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.add(builder);this.serviceItems.add(builder);} return (T)this;
    }
    public T removeFromServiceItems( Service ...items){
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.remove(builder);this.serviceItems.remove(builder);} return (T)this;
    }
    public ServiceItemsNested<T> addNewServiceItem(){
    return new ServiceItemsNested<T>();
    }
    public ServiceItemsNested<T> addNewServiceItemLike( Service item){
    return new ServiceItemsNested<T>(item);
    }
    public T addToRoleItems( Role ...items){
    for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.add(builder);this.roleItems.add(builder);} return (T)this;
    }
    public T removeFromRoleItems( Role ...items){
    for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.remove(builder);this.roleItems.remove(builder);} return (T)this;
    }
    public RoleItemsNested<T> addNewRoleItem(){
    return new RoleItemsNested<T>();
    }
    public RoleItemsNested<T> addNewRoleItemLike( Role item){
    return new RoleItemsNested<T>(item);
    }
    public T addToImageItems( Image ...items){
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.add(builder);this.imageItems.add(builder);} return (T)this;
    }
    public T removeFromImageItems( Image ...items){
    for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.remove(builder);this.imageItems.remove(builder);} return (T)this;
    }
    public ImageItemsNested<T> addNewImageItem(){
    return new ImageItemsNested<T>();
    }
    public ImageItemsNested<T> addNewImageItemLike( Image item){
    return new ImageItemsNested<T>(item);
    }
    public T addToClusterRoleBindingItems( ClusterRoleBinding ...items){
    for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.add(builder);this.clusterRoleBindingItems.add(builder);} return (T)this;
    }
    public T removeFromClusterRoleBindingItems( ClusterRoleBinding ...items){
    for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.remove(builder);this.clusterRoleBindingItems.remove(builder);} return (T)this;
    }
    public ClusterRoleBindingItemsNested<T> addNewClusterRoleBindingItem(){
    return new ClusterRoleBindingItemsNested<T>();
    }
    public ClusterRoleBindingItemsNested<T> addNewClusterRoleBindingItemLike( ClusterRoleBinding item){
    return new ClusterRoleBindingItemsNested<T>(item);
    }
    public T addToRouteItems( Route ...items){
    for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.add(builder);this.routeItems.add(builder);} return (T)this;
    }
    public T removeFromRouteItems( Route ...items){
    for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.remove(builder);this.routeItems.remove(builder);} return (T)this;
    }
    public RouteItemsNested<T> addNewRouteItem(){
    return new RouteItemsNested<T>();
    }
    public RouteItemsNested<T> addNewRouteItemLike( Route item){
    return new RouteItemsNested<T>(item);
    }
    public T addToImageStreamItems( ImageStream ...items){
    for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.add(builder);this.imageStreamItems.add(builder);} return (T)this;
    }
    public T removeFromImageStreamItems( ImageStream ...items){
    for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.remove(builder);this.imageStreamItems.remove(builder);} return (T)this;
    }
    public ImageStreamItemsNested<T> addNewImageStreamItem(){
    return new ImageStreamItemsNested<T>();
    }
    public ImageStreamItemsNested<T> addNewImageStreamItemLike( ImageStream item){
    return new ImageStreamItemsNested<T>(item);
    }
    public T addToTemplateItems( Template ...items){
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.add(builder);this.templateItems.add(builder);} return (T)this;
    }
    public T removeFromTemplateItems( Template ...items){
    for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.remove(builder);this.templateItems.remove(builder);} return (T)this;
    }
    public TemplateItemsNested<T> addNewTemplateItem(){
    return new TemplateItemsNested<T>();
    }
    public TemplateItemsNested<T> addNewTemplateItemLike( Template item){
    return new TemplateItemsNested<T>(item);
    }
    public T addToBuildConfigItems( BuildConfig ...items){
    for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.add(builder);this.buildConfigItems.add(builder);} return (T)this;
    }
    public T removeFromBuildConfigItems( BuildConfig ...items){
    for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.remove(builder);this.buildConfigItems.remove(builder);} return (T)this;
    }
    public BuildConfigItemsNested<T> addNewBuildConfigItem(){
    return new BuildConfigItemsNested<T>();
    }
    public BuildConfigItemsNested<T> addNewBuildConfigItemLike( BuildConfig item){
    return new BuildConfigItemsNested<T>(item);
    }
    public T addToServiceAccountItems( ServiceAccount ...items){
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.add(builder);this.serviceAccountItems.add(builder);} return (T)this;
    }
    public T removeFromServiceAccountItems( ServiceAccount ...items){
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.remove(builder);this.serviceAccountItems.remove(builder);} return (T)this;
    }
    public ServiceAccountItemsNested<T> addNewServiceAccountItem(){
    return new ServiceAccountItemsNested<T>();
    }
    public ServiceAccountItemsNested<T> addNewServiceAccountItemLike( ServiceAccount item){
    return new ServiceAccountItemsNested<T>(item);
    }
    public T addToGroupItems( Group ...items){
    for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.add(builder);this.groupItems.add(builder);} return (T)this;
    }
    public T removeFromGroupItems( Group ...items){
    for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.remove(builder);this.groupItems.remove(builder);} return (T)this;
    }
    public GroupItemsNested<T> addNewGroupItem(){
    return new GroupItemsNested<T>();
    }
    public GroupItemsNested<T> addNewGroupItemLike( Group item){
    return new GroupItemsNested<T>(item);
    }
    public T addToBuildItems( Build ...items){
    for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.add(builder);this.buildItems.add(builder);} return (T)this;
    }
    public T removeFromBuildItems( Build ...items){
    for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.remove(builder);this.buildItems.remove(builder);} return (T)this;
    }
    public BuildItemsNested<T> addNewBuildItem(){
    return new BuildItemsNested<T>();
    }
    public BuildItemsNested<T> addNewBuildItemLike( Build item){
    return new BuildItemsNested<T>(item);
    }
    public T addToResourceQuotaItems( ResourceQuota ...items){
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.add(builder);this.resourceQuotaItems.add(builder);} return (T)this;
    }
    public T removeFromResourceQuotaItems( ResourceQuota ...items){
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.remove(builder);this.resourceQuotaItems.remove(builder);} return (T)this;
    }
    public ResourceQuotaItemsNested<T> addNewResourceQuotaItem(){
    return new ResourceQuotaItemsNested<T>();
    }
    public ResourceQuotaItemsNested<T> addNewResourceQuotaItemLike( ResourceQuota item){
    return new ResourceQuotaItemsNested<T>(item);
    }
    public T addToSecretItems( Secret ...items){
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.add(builder);this.secretItems.add(builder);} return (T)this;
    }
    public T removeFromSecretItems( Secret ...items){
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.remove(builder);this.secretItems.remove(builder);} return (T)this;
    }
    public SecretItemsNested<T> addNewSecretItem(){
    return new SecretItemsNested<T>();
    }
    public SecretItemsNested<T> addNewSecretItemLike( Secret item){
    return new SecretItemsNested<T>(item);
    }
    public T addToPodItems( Pod ...items){
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.add(builder);this.podItems.add(builder);} return (T)this;
    }
    public T removeFromPodItems( Pod ...items){
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.remove(builder);this.podItems.remove(builder);} return (T)this;
    }
    public PodItemsNested<T> addNewPodItem(){
    return new PodItemsNested<T>();
    }
    public PodItemsNested<T> addNewPodItemLike( Pod item){
    return new PodItemsNested<T>(item);
    }
    public T addToPolicyBindingItems( PolicyBinding ...items){
    for (PolicyBinding item : items) {PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.add(builder);this.policyBindingItems.add(builder);} return (T)this;
    }
    public T removeFromPolicyBindingItems( PolicyBinding ...items){
    for (PolicyBinding item : items) {PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.remove(builder);this.policyBindingItems.remove(builder);} return (T)this;
    }
    public PolicyBindingItemsNested<T> addNewPolicyBindingItem(){
    return new PolicyBindingItemsNested<T>();
    }
    public PolicyBindingItemsNested<T> addNewPolicyBindingItemLike( PolicyBinding item){
    return new PolicyBindingItemsNested<T>(item);
    }
    public T addToPersistentVolumeClaimItems( PersistentVolumeClaim ...items){
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.add(builder);this.persistentVolumeClaimItems.add(builder);} return (T)this;
    }
    public T removeFromPersistentVolumeClaimItems( PersistentVolumeClaim ...items){
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.remove(builder);this.persistentVolumeClaimItems.remove(builder);} return (T)this;
    }
    public PersistentVolumeClaimItemsNested<T> addNewPersistentVolumeClaimItem(){
    return new PersistentVolumeClaimItemsNested<T>();
    }
    public PersistentVolumeClaimItemsNested<T> addNewPersistentVolumeClaimItemLike( PersistentVolumeClaim item){
    return new PersistentVolumeClaimItemsNested<T>(item);
    }
    public T addToIdentityItems( Identity ...items){
    for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.add(builder);this.identityItems.add(builder);} return (T)this;
    }
    public T removeFromIdentityItems( Identity ...items){
    for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.remove(builder);this.identityItems.remove(builder);} return (T)this;
    }
    public IdentityItemsNested<T> addNewIdentityItem(){
    return new IdentityItemsNested<T>();
    }
    public IdentityItemsNested<T> addNewIdentityItemLike( Identity item){
    return new IdentityItemsNested<T>(item);
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ListMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ListMeta metadata){
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ListMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T withNewMetadata( String resourceVersion,  String selfLink){
    return withMetadata(new ListMeta(resourceVersion, selfLink));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BaseKubernetesListFluent that = (BaseKubernetesListFluent) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (items != null ? !items.equals(that.items) :that.items != null) return false;
if (oAuthAccessTokenItems != null ? !oAuthAccessTokenItems.equals(that.oAuthAccessTokenItems) :that.oAuthAccessTokenItems != null) return false;
if (roleBindingItems != null ? !roleBindingItems.equals(that.roleBindingItems) :that.roleBindingItems != null) return false;
if (replicationControllerItems != null ? !replicationControllerItems.equals(that.replicationControllerItems) :that.replicationControllerItems != null) return false;
if (eventItems != null ? !eventItems.equals(that.eventItems) :that.eventItems != null) return false;
if (endpointsItems != null ? !endpointsItems.equals(that.endpointsItems) :that.endpointsItems != null) return false;
if (namespaceItems != null ? !namespaceItems.equals(that.namespaceItems) :that.namespaceItems != null) return false;
if (buildRequestItems != null ? !buildRequestItems.equals(that.buildRequestItems) :that.buildRequestItems != null) return false;
if (nodeItems != null ? !nodeItems.equals(that.nodeItems) :that.nodeItems != null) return false;
if (deploymentConfigItems != null ? !deploymentConfigItems.equals(that.deploymentConfigItems) :that.deploymentConfigItems != null) return false;
if (clusterPolicyBindingItems != null ? !clusterPolicyBindingItems.equals(that.clusterPolicyBindingItems) :that.clusterPolicyBindingItems != null) return false;
if (oAuthClientAuthorizationItems != null ? !oAuthClientAuthorizationItems.equals(that.oAuthClientAuthorizationItems) :that.oAuthClientAuthorizationItems != null) return false;
if (userItems != null ? !userItems.equals(that.userItems) :that.userItems != null) return false;
if (oAuthAuthorizeTokenItems != null ? !oAuthAuthorizeTokenItems.equals(that.oAuthAuthorizeTokenItems) :that.oAuthAuthorizeTokenItems != null) return false;
if (persistentVolumeItems != null ? !persistentVolumeItems.equals(that.persistentVolumeItems) :that.persistentVolumeItems != null) return false;
if (policyItems != null ? !policyItems.equals(that.policyItems) :that.policyItems != null) return false;
if (securityContextConstraintsItems != null ? !securityContextConstraintsItems.equals(that.securityContextConstraintsItems) :that.securityContextConstraintsItems != null) return false;
if (clusterPolicyItems != null ? !clusterPolicyItems.equals(that.clusterPolicyItems) :that.clusterPolicyItems != null) return false;
if (clusterRoleItems != null ? !clusterRoleItems.equals(that.clusterRoleItems) :that.clusterRoleItems != null) return false;
if (oAuthClientItems != null ? !oAuthClientItems.equals(that.oAuthClientItems) :that.oAuthClientItems != null) return false;
if (serviceItems != null ? !serviceItems.equals(that.serviceItems) :that.serviceItems != null) return false;
if (roleItems != null ? !roleItems.equals(that.roleItems) :that.roleItems != null) return false;
if (imageItems != null ? !imageItems.equals(that.imageItems) :that.imageItems != null) return false;
if (clusterRoleBindingItems != null ? !clusterRoleBindingItems.equals(that.clusterRoleBindingItems) :that.clusterRoleBindingItems != null) return false;
if (routeItems != null ? !routeItems.equals(that.routeItems) :that.routeItems != null) return false;
if (imageStreamItems != null ? !imageStreamItems.equals(that.imageStreamItems) :that.imageStreamItems != null) return false;
if (templateItems != null ? !templateItems.equals(that.templateItems) :that.templateItems != null) return false;
if (buildConfigItems != null ? !buildConfigItems.equals(that.buildConfigItems) :that.buildConfigItems != null) return false;
if (serviceAccountItems != null ? !serviceAccountItems.equals(that.serviceAccountItems) :that.serviceAccountItems != null) return false;
if (groupItems != null ? !groupItems.equals(that.groupItems) :that.groupItems != null) return false;
if (buildItems != null ? !buildItems.equals(that.buildItems) :that.buildItems != null) return false;
if (resourceQuotaItems != null ? !resourceQuotaItems.equals(that.resourceQuotaItems) :that.resourceQuotaItems != null) return false;
if (secretItems != null ? !secretItems.equals(that.secretItems) :that.secretItems != null) return false;
if (podItems != null ? !podItems.equals(that.podItems) :that.podItems != null) return false;
if (policyBindingItems != null ? !policyBindingItems.equals(that.policyBindingItems) :that.policyBindingItems != null) return false;
if (persistentVolumeClaimItems != null ? !persistentVolumeClaimItems.equals(that.persistentVolumeClaimItems) :that.persistentVolumeClaimItems != null) return false;
if (identityItems != null ? !identityItems.equals(that.identityItems) :that.identityItems != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class OAuthAccessTokenItemsNested<N> extends OAuthAccessTokenFluent<OAuthAccessTokenItemsNested<N>> implements Nested<N>{

        private final OAuthAccessTokenBuilder builder;
    
             OAuthAccessTokenItemsNested (){
        this.builder = new OAuthAccessTokenBuilder(this);
        }
             OAuthAccessTokenItemsNested ( OAuthAccessToken item){
        this.builder = new OAuthAccessTokenBuilder(this, item);
        }
    
            public N endOAuthAccessTokenItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToOAuthAccessTokenItems(builder.build());
        }
    
}
    public class RoleBindingItemsNested<N> extends RoleBindingFluent<RoleBindingItemsNested<N>> implements Nested<N>{

        private final RoleBindingBuilder builder;
    
             RoleBindingItemsNested (){
        this.builder = new RoleBindingBuilder(this);
        }
             RoleBindingItemsNested ( RoleBinding item){
        this.builder = new RoleBindingBuilder(this, item);
        }
    
            public N endRoleBindingItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToRoleBindingItems(builder.build());
        }
    
}
    public class ReplicationControllerItemsNested<N> extends ReplicationControllerFluent<ReplicationControllerItemsNested<N>> implements Nested<N>{

        private final ReplicationControllerBuilder builder;
    
             ReplicationControllerItemsNested (){
        this.builder = new ReplicationControllerBuilder(this);
        }
             ReplicationControllerItemsNested ( ReplicationController item){
        this.builder = new ReplicationControllerBuilder(this, item);
        }
    
            public N endReplicationControllerItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToReplicationControllerItems(builder.build());
        }
    
}
    public class EventItemsNested<N> extends EventFluent<EventItemsNested<N>> implements Nested<N>{

        private final EventBuilder builder;
    
             EventItemsNested (){
        this.builder = new EventBuilder(this);
        }
             EventItemsNested ( Event item){
        this.builder = new EventBuilder(this, item);
        }
    
            public N endEventItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToEventItems(builder.build());
        }
    
}
    public class EndpointsItemsNested<N> extends EndpointsFluent<EndpointsItemsNested<N>> implements Nested<N>{

        private final EndpointsBuilder builder;
    
             EndpointsItemsNested (){
        this.builder = new EndpointsBuilder(this);
        }
             EndpointsItemsNested ( Endpoints item){
        this.builder = new EndpointsBuilder(this, item);
        }
    
            public N endEndpointsItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToEndpointsItems(builder.build());
        }
    
}
    public class NamespaceItemsNested<N> extends NamespaceFluent<NamespaceItemsNested<N>> implements Nested<N>{

        private final NamespaceBuilder builder;
    
             NamespaceItemsNested (){
        this.builder = new NamespaceBuilder(this);
        }
             NamespaceItemsNested ( Namespace item){
        this.builder = new NamespaceBuilder(this, item);
        }
    
            public N endNamespaceItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToNamespaceItems(builder.build());
        }
    
}
    public class BuildRequestItemsNested<N> extends BuildRequestFluent<BuildRequestItemsNested<N>> implements Nested<N>{

        private final BuildRequestBuilder builder;
    
             BuildRequestItemsNested (){
        this.builder = new BuildRequestBuilder(this);
        }
             BuildRequestItemsNested ( BuildRequest item){
        this.builder = new BuildRequestBuilder(this, item);
        }
    
            public N endBuildRequestItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToBuildRequestItems(builder.build());
        }
    
}
    public class NodeItemsNested<N> extends NodeFluent<NodeItemsNested<N>> implements Nested<N>{

        private final NodeBuilder builder;
    
             NodeItemsNested (){
        this.builder = new NodeBuilder(this);
        }
             NodeItemsNested ( Node item){
        this.builder = new NodeBuilder(this, item);
        }
    
            public N endNodeItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToNodeItems(builder.build());
        }
    
}
    public class DeploymentConfigItemsNested<N> extends DeploymentConfigFluent<DeploymentConfigItemsNested<N>> implements Nested<N>{

        private final DeploymentConfigBuilder builder;
    
             DeploymentConfigItemsNested (){
        this.builder = new DeploymentConfigBuilder(this);
        }
             DeploymentConfigItemsNested ( DeploymentConfig item){
        this.builder = new DeploymentConfigBuilder(this, item);
        }
    
            public N endDeploymentConfigItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToDeploymentConfigItems(builder.build());
        }
    
}
    public class ClusterPolicyBindingItemsNested<N> extends ClusterPolicyBindingFluent<ClusterPolicyBindingItemsNested<N>> implements Nested<N>{

        private final ClusterPolicyBindingBuilder builder;
    
             ClusterPolicyBindingItemsNested (){
        this.builder = new ClusterPolicyBindingBuilder(this);
        }
             ClusterPolicyBindingItemsNested ( ClusterPolicyBinding item){
        this.builder = new ClusterPolicyBindingBuilder(this, item);
        }
    
            public N endClusterPolicyBindingItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToClusterPolicyBindingItems(builder.build());
        }
    
}
    public class OAuthClientAuthorizationItemsNested<N> extends OAuthClientAuthorizationFluent<OAuthClientAuthorizationItemsNested<N>> implements Nested<N>{

        private final OAuthClientAuthorizationBuilder builder;
    
             OAuthClientAuthorizationItemsNested (){
        this.builder = new OAuthClientAuthorizationBuilder(this);
        }
             OAuthClientAuthorizationItemsNested ( OAuthClientAuthorization item){
        this.builder = new OAuthClientAuthorizationBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToOAuthClientAuthorizationItems(builder.build());
        }
            public N endOAuthClientAuthorizationItem(){
            return and();
        }
    
}
    public class UserItemsNested<N> extends UserFluent<UserItemsNested<N>> implements Nested<N>{

        private final UserBuilder builder;
    
             UserItemsNested (){
        this.builder = new UserBuilder(this);
        }
             UserItemsNested ( User item){
        this.builder = new UserBuilder(this, item);
        }
    
            public N endUserItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToUserItems(builder.build());
        }
    
}
    public class OAuthAuthorizeTokenItemsNested<N> extends OAuthAuthorizeTokenFluent<OAuthAuthorizeTokenItemsNested<N>> implements Nested<N>{

        private final OAuthAuthorizeTokenBuilder builder;
    
             OAuthAuthorizeTokenItemsNested (){
        this.builder = new OAuthAuthorizeTokenBuilder(this);
        }
             OAuthAuthorizeTokenItemsNested ( OAuthAuthorizeToken item){
        this.builder = new OAuthAuthorizeTokenBuilder(this, item);
        }
    
            public N endOAuthAuthorizeTokenItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToOAuthAuthorizeTokenItems(builder.build());
        }
    
}
    public class PersistentVolumeItemsNested<N> extends PersistentVolumeFluent<PersistentVolumeItemsNested<N>> implements Nested<N>{

        private final PersistentVolumeBuilder builder;
    
             PersistentVolumeItemsNested (){
        this.builder = new PersistentVolumeBuilder(this);
        }
             PersistentVolumeItemsNested ( PersistentVolume item){
        this.builder = new PersistentVolumeBuilder(this, item);
        }
    
            public N endPersistentVolumeItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToPersistentVolumeItems(builder.build());
        }
    
}
    public class PolicyItemsNested<N> extends PolicyFluent<PolicyItemsNested<N>> implements Nested<N>{

        private final PolicyBuilder builder;
    
             PolicyItemsNested (){
        this.builder = new PolicyBuilder(this);
        }
             PolicyItemsNested ( Policy item){
        this.builder = new PolicyBuilder(this, item);
        }
    
            public N endPolicyItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToPolicyItems(builder.build());
        }
    
}
    public class SecurityContextConstraintsItemsNested<N> extends SecurityContextConstraintsFluent<SecurityContextConstraintsItemsNested<N>> implements Nested<N>{

        private final SecurityContextConstraintsBuilder builder;
    
             SecurityContextConstraintsItemsNested (){
        this.builder = new SecurityContextConstraintsBuilder(this);
        }
             SecurityContextConstraintsItemsNested ( SecurityContextConstraints item){
        this.builder = new SecurityContextConstraintsBuilder(this, item);
        }
    
            public N endSecurityContextConstraintsItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToSecurityContextConstraintsItems(builder.build());
        }
    
}
    public class ClusterPolicyItemsNested<N> extends ClusterPolicyFluent<ClusterPolicyItemsNested<N>> implements Nested<N>{

        private final ClusterPolicyBuilder builder;
    
             ClusterPolicyItemsNested (){
        this.builder = new ClusterPolicyBuilder(this);
        }
             ClusterPolicyItemsNested ( ClusterPolicy item){
        this.builder = new ClusterPolicyBuilder(this, item);
        }
    
            public N endClusterPolicyItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToClusterPolicyItems(builder.build());
        }
    
}
    public class ClusterRoleItemsNested<N> extends ClusterRoleFluent<ClusterRoleItemsNested<N>> implements Nested<N>{

        private final ClusterRoleBuilder builder;
    
             ClusterRoleItemsNested (){
        this.builder = new ClusterRoleBuilder(this);
        }
             ClusterRoleItemsNested ( ClusterRole item){
        this.builder = new ClusterRoleBuilder(this, item);
        }
    
            public N endClusterRoleItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToClusterRoleItems(builder.build());
        }
    
}
    public class OAuthClientItemsNested<N> extends OAuthClientFluent<OAuthClientItemsNested<N>> implements Nested<N>{

        private final OAuthClientBuilder builder;
    
             OAuthClientItemsNested (){
        this.builder = new OAuthClientBuilder(this);
        }
             OAuthClientItemsNested ( OAuthClient item){
        this.builder = new OAuthClientBuilder(this, item);
        }
    
            public N endOAuthClientItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToOAuthClientItems(builder.build());
        }
    
}
    public class ServiceItemsNested<N> extends ServiceFluent<ServiceItemsNested<N>> implements Nested<N>{

        private final ServiceBuilder builder;
    
             ServiceItemsNested (){
        this.builder = new ServiceBuilder(this);
        }
             ServiceItemsNested ( Service item){
        this.builder = new ServiceBuilder(this, item);
        }
    
            public N endServiceItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToServiceItems(builder.build());
        }
    
}
    public class RoleItemsNested<N> extends RoleFluent<RoleItemsNested<N>> implements Nested<N>{

        private final RoleBuilder builder;
    
             RoleItemsNested (){
        this.builder = new RoleBuilder(this);
        }
             RoleItemsNested ( Role item){
        this.builder = new RoleBuilder(this, item);
        }
    
            public N endRoleItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToRoleItems(builder.build());
        }
    
}
    public class ImageItemsNested<N> extends ImageFluent<ImageItemsNested<N>> implements Nested<N>{

        private final ImageBuilder builder;
    
             ImageItemsNested (){
        this.builder = new ImageBuilder(this);
        }
             ImageItemsNested ( Image item){
        this.builder = new ImageBuilder(this, item);
        }
    
            public N endImageItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToImageItems(builder.build());
        }
    
}
    public class ClusterRoleBindingItemsNested<N> extends ClusterRoleBindingFluent<ClusterRoleBindingItemsNested<N>> implements Nested<N>{

        private final ClusterRoleBindingBuilder builder;
    
             ClusterRoleBindingItemsNested (){
        this.builder = new ClusterRoleBindingBuilder(this);
        }
             ClusterRoleBindingItemsNested ( ClusterRoleBinding item){
        this.builder = new ClusterRoleBindingBuilder(this, item);
        }
    
            public N endClusterRoleBindingItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToClusterRoleBindingItems(builder.build());
        }
    
}
    public class RouteItemsNested<N> extends RouteFluent<RouteItemsNested<N>> implements Nested<N>{

        private final RouteBuilder builder;
    
             RouteItemsNested (){
        this.builder = new RouteBuilder(this);
        }
             RouteItemsNested ( Route item){
        this.builder = new RouteBuilder(this, item);
        }
    
            public N endRouteItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToRouteItems(builder.build());
        }
    
}
    public class ImageStreamItemsNested<N> extends ImageStreamFluent<ImageStreamItemsNested<N>> implements Nested<N>{

        private final ImageStreamBuilder builder;
    
             ImageStreamItemsNested (){
        this.builder = new ImageStreamBuilder(this);
        }
             ImageStreamItemsNested ( ImageStream item){
        this.builder = new ImageStreamBuilder(this, item);
        }
    
            public N endImageStreamItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToImageStreamItems(builder.build());
        }
    
}
    public class TemplateItemsNested<N> extends TemplateFluent<TemplateItemsNested<N>> implements Nested<N>{

        private final TemplateBuilder builder;
    
             TemplateItemsNested (){
        this.builder = new TemplateBuilder(this);
        }
             TemplateItemsNested ( Template item){
        this.builder = new TemplateBuilder(this, item);
        }
    
            public N endTemplateItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToTemplateItems(builder.build());
        }
    
}
    public class BuildConfigItemsNested<N> extends BuildConfigFluent<BuildConfigItemsNested<N>> implements Nested<N>{

        private final BuildConfigBuilder builder;
    
             BuildConfigItemsNested (){
        this.builder = new BuildConfigBuilder(this);
        }
             BuildConfigItemsNested ( BuildConfig item){
        this.builder = new BuildConfigBuilder(this, item);
        }
    
            public N endBuildConfigItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToBuildConfigItems(builder.build());
        }
    
}
    public class ServiceAccountItemsNested<N> extends ServiceAccountFluent<ServiceAccountItemsNested<N>> implements Nested<N>{

        private final ServiceAccountBuilder builder;
    
             ServiceAccountItemsNested (){
        this.builder = new ServiceAccountBuilder(this);
        }
             ServiceAccountItemsNested ( ServiceAccount item){
        this.builder = new ServiceAccountBuilder(this, item);
        }
    
            public N endServiceAccountItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToServiceAccountItems(builder.build());
        }
    
}
    public class GroupItemsNested<N> extends GroupFluent<GroupItemsNested<N>> implements Nested<N>{

        private final GroupBuilder builder;
    
             GroupItemsNested (){
        this.builder = new GroupBuilder(this);
        }
             GroupItemsNested ( Group item){
        this.builder = new GroupBuilder(this, item);
        }
    
            public N endGroupItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToGroupItems(builder.build());
        }
    
}
    public class BuildItemsNested<N> extends BuildFluent<BuildItemsNested<N>> implements Nested<N>{

        private final BuildBuilder builder;
    
             BuildItemsNested (){
        this.builder = new BuildBuilder(this);
        }
             BuildItemsNested ( Build item){
        this.builder = new BuildBuilder(this, item);
        }
    
            public N endBuildItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToBuildItems(builder.build());
        }
    
}
    public class ResourceQuotaItemsNested<N> extends ResourceQuotaFluent<ResourceQuotaItemsNested<N>> implements Nested<N>{

        private final ResourceQuotaBuilder builder;
    
             ResourceQuotaItemsNested (){
        this.builder = new ResourceQuotaBuilder(this);
        }
             ResourceQuotaItemsNested ( ResourceQuota item){
        this.builder = new ResourceQuotaBuilder(this, item);
        }
    
            public N endResourceQuotaItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToResourceQuotaItems(builder.build());
        }
    
}
    public class SecretItemsNested<N> extends SecretFluent<SecretItemsNested<N>> implements Nested<N>{

        private final SecretBuilder builder;
    
             SecretItemsNested (){
        this.builder = new SecretBuilder(this);
        }
             SecretItemsNested ( Secret item){
        this.builder = new SecretBuilder(this, item);
        }
    
            public N endSecretItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToSecretItems(builder.build());
        }
    
}
    public class PodItemsNested<N> extends PodFluent<PodItemsNested<N>> implements Nested<N>{

        private final PodBuilder builder;
    
             PodItemsNested (){
        this.builder = new PodBuilder(this);
        }
             PodItemsNested ( Pod item){
        this.builder = new PodBuilder(this, item);
        }
    
            public N endPodItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToPodItems(builder.build());
        }
    
}
    public class PolicyBindingItemsNested<N> extends PolicyBindingFluent<PolicyBindingItemsNested<N>> implements Nested<N>{

        private final PolicyBindingBuilder builder;
    
             PolicyBindingItemsNested (){
        this.builder = new PolicyBindingBuilder(this);
        }
             PolicyBindingItemsNested ( PolicyBinding item){
        this.builder = new PolicyBindingBuilder(this, item);
        }
    
            public N endPolicyBindingItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToPolicyBindingItems(builder.build());
        }
    
}
    public class PersistentVolumeClaimItemsNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimItemsNested<N>> implements Nested<N>{

        private final PersistentVolumeClaimBuilder builder;
    
             PersistentVolumeClaimItemsNested (){
        this.builder = new PersistentVolumeClaimBuilder(this);
        }
             PersistentVolumeClaimItemsNested ( PersistentVolumeClaim item){
        this.builder = new PersistentVolumeClaimBuilder(this, item);
        }
    
            public N endPersistentVolumeClaimItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToPersistentVolumeClaimItems(builder.build());
        }
    
}
    public class IdentityItemsNested<N> extends IdentityFluent<IdentityItemsNested<N>> implements Nested<N>{

        private final IdentityBuilder builder;
    
             IdentityItemsNested (){
        this.builder = new IdentityBuilder(this);
        }
             IdentityItemsNested ( Identity item){
        this.builder = new IdentityBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToIdentityItems(builder.build());
        }
            public N endIdentityItem(){
            return and();
        }
    
}
    public class MetadataNested<N> extends ListMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ListMetaBuilder builder;
    
             MetadataNested (){
        this.builder = new ListMetaBuilder(this);
        }
             MetadataNested ( ListMeta item){
        this.builder = new ListMetaBuilder(this, item);
        }
    
            public N endMetadata(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.withMetadata(builder.build());
        }
    
}


}
