
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "fsType",
    "iqn",
    "lun",
    "readOnly",
    "targetPortal"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class ISCSIVolumeSource {

    /**
     * file system type to mount
     * 
     */
    @JsonProperty("fsType")
    private String fsType;
    /**
     * iSCSI Qualified Name
     * 
     */
    @JsonProperty("iqn")
    private String iqn;
    /**
     * iscsi target lun number
     * 
     */
    @JsonProperty("lun")
    private Integer lun;
    /**
     * read-only if true
     * 
     */
    @JsonProperty("readOnly")
    private Boolean readOnly;
    /**
     * iSCSI target portal
     * 
     */
    @JsonProperty("targetPortal")
    private String targetPortal;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ISCSIVolumeSource() {
    }

    /**
     * 
     * @param targetPortal
     * @param fsType
     * @param readOnly
     * @param lun
     * @param iqn
     */
    public ISCSIVolumeSource(String fsType, String iqn, Integer lun, Boolean readOnly, String targetPortal) {
        this.fsType = fsType;
        this.iqn = iqn;
        this.lun = lun;
        this.readOnly = readOnly;
        this.targetPortal = targetPortal;
    }

    /**
     * file system type to mount
     * 
     * @return
     *     The fsType
     */
    @JsonProperty("fsType")
    public String getFsType() {
        return fsType;
    }

    /**
     * file system type to mount
     * 
     * @param fsType
     *     The fsType
     */
    @JsonProperty("fsType")
    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    /**
     * iSCSI Qualified Name
     * 
     * @return
     *     The iqn
     */
    @JsonProperty("iqn")
    public String getIqn() {
        return iqn;
    }

    /**
     * iSCSI Qualified Name
     * 
     * @param iqn
     *     The iqn
     */
    @JsonProperty("iqn")
    public void setIqn(String iqn) {
        this.iqn = iqn;
    }

    /**
     * iscsi target lun number
     * 
     * @return
     *     The lun
     */
    @JsonProperty("lun")
    public Integer getLun() {
        return lun;
    }

    /**
     * iscsi target lun number
     * 
     * @param lun
     *     The lun
     */
    @JsonProperty("lun")
    public void setLun(Integer lun) {
        this.lun = lun;
    }

    /**
     * read-only if true
     * 
     * @return
     *     The readOnly
     */
    @JsonProperty("readOnly")
    public Boolean getReadOnly() {
        return readOnly;
    }

    /**
     * read-only if true
     * 
     * @param readOnly
     *     The readOnly
     */
    @JsonProperty("readOnly")
    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    /**
     * iSCSI target portal
     * 
     * @return
     *     The targetPortal
     */
    @JsonProperty("targetPortal")
    public String getTargetPortal() {
        return targetPortal;
    }

    /**
     * iSCSI target portal
     * 
     * @param targetPortal
     *     The targetPortal
     */
    @JsonProperty("targetPortal")
    public void setTargetPortal(String targetPortal) {
        this.targetPortal = targetPortal;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
