
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "conditions",
    "containerStatuses",
    "hostIP",
    "message",
    "phase",
    "podIP",
    "reason",
    "startTime"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class PodStatus {

    /**
     * current service state of pod; see http://releases.k8s.io/v1.0.0/docs/pod-states.md#pod-conditions
     * 
     */
    @JsonProperty("conditions")
    @Valid
    private List<PodCondition> conditions = new ArrayList<PodCondition>();
    /**
     * list of container statuses; see http://releases.k8s.io/v1.0.0/docs/pod-states.md#container-statuses
     * 
     */
    @JsonProperty("containerStatuses")
    @Valid
    private List<ContainerStatus> containerStatuses = new ArrayList<ContainerStatus>();
    /**
     * IP address of the host to which the pod is assigned; empty if not yet scheduled
     * 
     */
    @JsonProperty("hostIP")
    private String hostIP;
    /**
     * human readable message indicating details about why the pod is in this condition
     * 
     */
    @JsonProperty("message")
    private String message;
    /**
     * current condition of the pod; see http://releases.k8s.io/v1.0.0/docs/pod-states.md#pod-phase
     * 
     */
    @JsonProperty("phase")
    private String phase;
    /**
     * IP address allocated to the pod; routable at least within the cluster; empty if not yet allocated
     * 
     */
    @JsonProperty("podIP")
    private String podIP;
    /**
     * (brief-CamelCase) reason indicating details about why the pod is in this condition
     * 
     */
    @JsonProperty("reason")
    private String reason;
    /**
     * RFC 3339 date and time at which the object was acknowledged by the Kubelet.  This is before the Kubelet pulled the container image(s) for the pod.
     * 
     */
    @JsonProperty("startTime")
    private String startTime;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public PodStatus() {
    }

    /**
     * 
     * @param startTime
     * @param message
     * @param conditions
     * @param reason
     * @param podIP
     * @param hostIP
     * @param phase
     * @param containerStatuses
     */
    public PodStatus(List<PodCondition> conditions, List<ContainerStatus> containerStatuses, String hostIP, String message, String phase, String podIP, String reason, String startTime) {
        this.conditions = conditions;
        this.containerStatuses = containerStatuses;
        this.hostIP = hostIP;
        this.message = message;
        this.phase = phase;
        this.podIP = podIP;
        this.reason = reason;
        this.startTime = startTime;
    }

    /**
     * current service state of pod; see http://releases.k8s.io/v1.0.0/docs/pod-states.md#pod-conditions
     * 
     * @return
     *     The conditions
     */
    @JsonProperty("conditions")
    public List<PodCondition> getConditions() {
        return conditions;
    }

    /**
     * current service state of pod; see http://releases.k8s.io/v1.0.0/docs/pod-states.md#pod-conditions
     * 
     * @param conditions
     *     The conditions
     */
    @JsonProperty("conditions")
    public void setConditions(List<PodCondition> conditions) {
        this.conditions = conditions;
    }

    /**
     * list of container statuses; see http://releases.k8s.io/v1.0.0/docs/pod-states.md#container-statuses
     * 
     * @return
     *     The containerStatuses
     */
    @JsonProperty("containerStatuses")
    public List<ContainerStatus> getContainerStatuses() {
        return containerStatuses;
    }

    /**
     * list of container statuses; see http://releases.k8s.io/v1.0.0/docs/pod-states.md#container-statuses
     * 
     * @param containerStatuses
     *     The containerStatuses
     */
    @JsonProperty("containerStatuses")
    public void setContainerStatuses(List<ContainerStatus> containerStatuses) {
        this.containerStatuses = containerStatuses;
    }

    /**
     * IP address of the host to which the pod is assigned; empty if not yet scheduled
     * 
     * @return
     *     The hostIP
     */
    @JsonProperty("hostIP")
    public String getHostIP() {
        return hostIP;
    }

    /**
     * IP address of the host to which the pod is assigned; empty if not yet scheduled
     * 
     * @param hostIP
     *     The hostIP
     */
    @JsonProperty("hostIP")
    public void setHostIP(String hostIP) {
        this.hostIP = hostIP;
    }

    /**
     * human readable message indicating details about why the pod is in this condition
     * 
     * @return
     *     The message
     */
    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    /**
     * human readable message indicating details about why the pod is in this condition
     * 
     * @param message
     *     The message
     */
    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * current condition of the pod; see http://releases.k8s.io/v1.0.0/docs/pod-states.md#pod-phase
     * 
     * @return
     *     The phase
     */
    @JsonProperty("phase")
    public String getPhase() {
        return phase;
    }

    /**
     * current condition of the pod; see http://releases.k8s.io/v1.0.0/docs/pod-states.md#pod-phase
     * 
     * @param phase
     *     The phase
     */
    @JsonProperty("phase")
    public void setPhase(String phase) {
        this.phase = phase;
    }

    /**
     * IP address allocated to the pod; routable at least within the cluster; empty if not yet allocated
     * 
     * @return
     *     The podIP
     */
    @JsonProperty("podIP")
    public String getPodIP() {
        return podIP;
    }

    /**
     * IP address allocated to the pod; routable at least within the cluster; empty if not yet allocated
     * 
     * @param podIP
     *     The podIP
     */
    @JsonProperty("podIP")
    public void setPodIP(String podIP) {
        this.podIP = podIP;
    }

    /**
     * (brief-CamelCase) reason indicating details about why the pod is in this condition
     * 
     * @return
     *     The reason
     */
    @JsonProperty("reason")
    public String getReason() {
        return reason;
    }

    /**
     * (brief-CamelCase) reason indicating details about why the pod is in this condition
     * 
     * @param reason
     *     The reason
     */
    @JsonProperty("reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    /**
     * RFC 3339 date and time at which the object was acknowledged by the Kubelet.  This is before the Kubelet pulled the container image(s) for the pod.
     * 
     * @return
     *     The startTime
     */
    @JsonProperty("startTime")
    public String getStartTime() {
        return startTime;
    }

    /**
     * RFC 3339 date and time at which the object was acknowledged by the Kubelet.  This is before the Kubelet pulled the container image(s) for the pod.
     * 
     * @param startTime
     *     The startTime
     */
    @JsonProperty("startTime")
    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
