
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "hard"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class ResourceQuotaSpec {

    /**
     * hard is the set of desired hard limits for each named resource; see http://releases.k8s.io/v1.0.0/docs/design/admission_control_resource_quota.md#admissioncontrol-plugin-resourcequota
     * 
     */
    @JsonProperty("hard")
    @Valid
    private Map<String, Quantity> hard;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ResourceQuotaSpec() {
    }

    /**
     * 
     * @param hard
     */
    public ResourceQuotaSpec(Map<String, Quantity> hard) {
        this.hard = hard;
    }

    /**
     * hard is the set of desired hard limits for each named resource; see http://releases.k8s.io/v1.0.0/docs/design/admission_control_resource_quota.md#admissioncontrol-plugin-resourcequota
     * 
     * @return
     *     The hard
     */
    @JsonProperty("hard")
    public Map<String, Quantity> getHard() {
        return hard;
    }

    /**
     * hard is the set of desired hard limits for each named resource; see http://releases.k8s.io/v1.0.0/docs/design/admission_control_resource_quota.md#admissioncontrol-plugin-resourcequota
     * 
     * @param hard
     *     The hard
     */
    @JsonProperty("hard")
    public void setHard(Map<String, Quantity> hard) {
        this.hard = hard;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
