
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "causes",
    "kind",
    "name",
    "retryAfterSeconds"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class StatusDetails {

    /**
     * the Causes array includes more details associated with the StatusReason failure; not all StatusReasons may provide detailed causes
     * 
     */
    @JsonProperty("causes")
    @Valid
    private List<StatusCause> causes = new ArrayList<StatusCause>();
    /**
     * the kind attribute of the resource associated with the status StatusReason; on some operations may differ from the requested resource Kind; see http://releases.k8s.io/v1.0.0/docs/api-conventions.md#types-kinds
     * 
     */
    @JsonProperty("kind")
    private String kind;
    /**
     * the name attribute of the resource associated with the status StatusReason (when there is a single name which can be described)
     * 
     */
    @JsonProperty("name")
    private String name;
    /**
     * the number of seconds before the client should attempt to retry this operation
     * 
     */
    @JsonProperty("retryAfterSeconds")
    private Integer retryAfterSeconds;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public StatusDetails() {
    }

    /**
     * 
     * @param retryAfterSeconds
     * @param name
     * @param causes
     * @param kind
     */
    public StatusDetails(List<StatusCause> causes, String kind, String name, Integer retryAfterSeconds) {
        this.causes = causes;
        this.kind = kind;
        this.name = name;
        this.retryAfterSeconds = retryAfterSeconds;
    }

    /**
     * the Causes array includes more details associated with the StatusReason failure; not all StatusReasons may provide detailed causes
     * 
     * @return
     *     The causes
     */
    @JsonProperty("causes")
    public List<StatusCause> getCauses() {
        return causes;
    }

    /**
     * the Causes array includes more details associated with the StatusReason failure; not all StatusReasons may provide detailed causes
     * 
     * @param causes
     *     The causes
     */
    @JsonProperty("causes")
    public void setCauses(List<StatusCause> causes) {
        this.causes = causes;
    }

    /**
     * the kind attribute of the resource associated with the status StatusReason; on some operations may differ from the requested resource Kind; see http://releases.k8s.io/v1.0.0/docs/api-conventions.md#types-kinds
     * 
     * @return
     *     The kind
     */
    @JsonProperty("kind")
    public String getKind() {
        return kind;
    }

    /**
     * the kind attribute of the resource associated with the status StatusReason; on some operations may differ from the requested resource Kind; see http://releases.k8s.io/v1.0.0/docs/api-conventions.md#types-kinds
     * 
     * @param kind
     *     The kind
     */
    @JsonProperty("kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    /**
     * the name attribute of the resource associated with the status StatusReason (when there is a single name which can be described)
     * 
     * @return
     *     The name
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * the name attribute of the resource associated with the status StatusReason (when there is a single name which can be described)
     * 
     * @param name
     *     The name
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * the number of seconds before the client should attempt to retry this operation
     * 
     * @return
     *     The retryAfterSeconds
     */
    @JsonProperty("retryAfterSeconds")
    public Integer getRetryAfterSeconds() {
        return retryAfterSeconds;
    }

    /**
     * the number of seconds before the client should attempt to retry this operation
     * 
     * @param retryAfterSeconds
     *     The retryAfterSeconds
     */
    @JsonProperty("retryAfterSeconds")
    public void setRetryAfterSeconds(Integer retryAfterSeconds) {
        this.retryAfterSeconds = retryAfterSeconds;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
