package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class BuildListBuilder extends BuildListFluent<BuildListBuilder> implements VisitableBuilder<BuildList,BuildListBuilder>{

     BuildListFluent<?> fluent;
public BuildListBuilder(){
    this(new BuildList());
}
public BuildListBuilder( BuildListFluent<?> fluent ){
    this(fluent, new BuildList());
}
public BuildListBuilder( BuildListFluent<?> fluent , BuildList instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withItems(instance.getItems()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); 
}
public BuildListBuilder( BuildList instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withItems(instance.getItems()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); 
}

public EditableBuildList build(){
    EditableBuildList buildable = new EditableBuildList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
BuildListBuilder that = (BuildListBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    