package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ImageStreamStatusFluent<T extends ImageStreamStatusFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String dockerImageRepository;     List<VisitableBuilder<NamedTagEventList, ?>> tags = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public String getDockerImageRepository(){
    return this.dockerImageRepository;
    }
    public T withDockerImageRepository( String dockerImageRepository){
    this.dockerImageRepository=dockerImageRepository; return (T) this;
    }
    public T addToTags( NamedTagEventList ...items){
    for (NamedTagEventList item : items) {NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);_visitables.add(builder);this.tags.add(builder);} return (T)this;
    }
    public T removeFromTags( NamedTagEventList ...items){
    for (NamedTagEventList item : items) {NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);_visitables.remove(builder);this.tags.remove(builder);} return (T)this;
    }
    public List<NamedTagEventList> getTags(){
    return build(tags);
    }
    public T withTags( List<NamedTagEventList> tags){
    this.tags.clear();if (tags != null) {for (NamedTagEventList item : tags){this.addToTags(item);}} return (T) this;
    }
    public T withTags( NamedTagEventList ...tags){
    this.tags.clear(); if (tags != null) {for (NamedTagEventList item :tags){ this.addToTags(item);}} return (T) this;
    }
    public TagsNested<T> addNewTag(){
    return new TagsNested<T>();
    }
    public TagsNested<T> addNewTagLike( NamedTagEventList item){
    return new TagsNested<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ImageStreamStatusFluent that = (ImageStreamStatusFluent) o;
if (dockerImageRepository != null ? !dockerImageRepository.equals(that.dockerImageRepository) :that.dockerImageRepository != null) return false;
if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class TagsNested<N> extends NamedTagEventListFluent<TagsNested<N>> implements Nested<N>{

        private final NamedTagEventListBuilder builder;
    
             TagsNested ( NamedTagEventList item){
        this.builder = new NamedTagEventListBuilder(this, item);
        }
             TagsNested (){
        this.builder = new NamedTagEventListBuilder(this);
        }
    
            public N endTag(){
            return and();
        }
            public N and(){
            return (N) ImageStreamStatusFluent.this.addToTags(builder.build());
        }
    
}


}
