package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class OAuthAccessTokenBuilder extends OAuthAccessTokenFluent<OAuthAccessTokenBuilder> implements VisitableBuilder<OAuthAccessToken,OAuthAccessTokenBuilder>{

     OAuthAccessTokenFluent<?> fluent;
public OAuthAccessTokenBuilder(){
    this(new OAuthAccessToken());
}
public OAuthAccessTokenBuilder( OAuthAccessTokenFluent<?> fluent ){
    this(fluent, new OAuthAccessToken());
}
public OAuthAccessTokenBuilder( OAuthAccessTokenFluent<?> fluent , OAuthAccessToken instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withAuthorizeToken(instance.getAuthorizeToken()); fluent.withClientName(instance.getClientName()); fluent.withExpiresIn(instance.getExpiresIn()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); fluent.withRedirectURI(instance.getRedirectURI()); fluent.withRefreshToken(instance.getRefreshToken()); fluent.withScopes(instance.getScopes()); fluent.withUserName(instance.getUserName()); fluent.withUserUID(instance.getUserUID()); 
}
public OAuthAccessTokenBuilder( OAuthAccessToken instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withAuthorizeToken(instance.getAuthorizeToken()); this.withClientName(instance.getClientName()); this.withExpiresIn(instance.getExpiresIn()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withRedirectURI(instance.getRedirectURI()); this.withRefreshToken(instance.getRefreshToken()); this.withScopes(instance.getScopes()); this.withUserName(instance.getUserName()); this.withUserUID(instance.getUserUID()); 
}

public EditableOAuthAccessToken build(){
    EditableOAuthAccessToken buildable = new EditableOAuthAccessToken(fluent.getApiVersion(),fluent.getAuthorizeToken(),fluent.getClientName(),fluent.getExpiresIn(),fluent.getKind(),fluent.getMetadata(),fluent.getRedirectURI(),fluent.getRefreshToken(),fluent.getScopes(),fluent.getUserName(),fluent.getUserUID());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
OAuthAccessTokenBuilder that = (OAuthAccessTokenBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    