package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class RoleBindingFluent<T extends RoleBindingFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     RoleBinding.ApiVersion apiVersion;     List<String> groupNames = new ArrayList();     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<ObjectReference, ?> roleRef;     List<String> userNames = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public RoleBinding.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( RoleBinding.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToGroupNames( String ...items){
    for (String item : items) {this.groupNames.add(item);} return (T)this;
    }
    public T removeFromGroupNames( String ...items){
    for (String item : items) {this.groupNames.remove(item);} return (T)this;
    }
    public List<String> getGroupNames(){
    return this.groupNames;
    }
    public T withGroupNames( List<String> groupNames){
    this.groupNames.clear();if (groupNames != null) {for (String item : groupNames){this.addToGroupNames(item);}} return (T) this;
    }
    public T withGroupNames( String ...groupNames){
    this.groupNames.clear(); if (groupNames != null) {for (String item :groupNames){ this.addToGroupNames(item);}} return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public ObjectReference getRoleRef(){
    return this.roleRef!=null?this.roleRef.build():null;
    }
    public T withRoleRef( ObjectReference roleRef){
    if (roleRef!=null){ this.roleRef= new ObjectReferenceBuilder(roleRef); _visitables.add(this.roleRef);} return (T) this;
    }
    public RoleRefNested<T> withNewRoleRef(){
    return new RoleRefNested<T>();
    }
    public RoleRefNested<T> withNewRoleRefLike( ObjectReference item){
    return new RoleRefNested<T>(item);
    }
    public RoleRefNested<T> editRoleRef(){
    return withNewRoleRefLike(getRoleRef());
    }
    public T addToUserNames( String ...items){
    for (String item : items) {this.userNames.add(item);} return (T)this;
    }
    public T removeFromUserNames( String ...items){
    for (String item : items) {this.userNames.remove(item);} return (T)this;
    }
    public List<String> getUserNames(){
    return this.userNames;
    }
    public T withUserNames( List<String> userNames){
    this.userNames.clear();if (userNames != null) {for (String item : userNames){this.addToUserNames(item);}} return (T) this;
    }
    public T withUserNames( String ...userNames){
    this.userNames.clear(); if (userNames != null) {for (String item :userNames){ this.addToUserNames(item);}} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RoleBindingFluent that = (RoleBindingFluent) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (groupNames != null ? !groupNames.equals(that.groupNames) :that.groupNames != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (roleRef != null ? !roleRef.equals(that.roleRef) :that.roleRef != null) return false;
if (userNames != null ? !userNames.equals(that.userNames) :that.userNames != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N endMetadata(){
            return and();
        }
            public N and(){
            return (N) RoleBindingFluent.this.withMetadata(builder.build());
        }
    
}
    public class RoleRefNested<N> extends ObjectReferenceFluent<RoleRefNested<N>> implements Nested<N>{

        private final ObjectReferenceBuilder builder;
    
             RoleRefNested (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             RoleRefNested ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N endRoleRef(){
            return and();
        }
            public N and(){
            return (N) RoleBindingFluent.this.withRoleRef(builder.build());
        }
    
}


}
