package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class EventSourceFluent<T extends EventSourceFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String component;     String host;     Map<String, Object> additionalProperties = new HashMap();

    public String getComponent(){
    return this.component;
    }
    public T withComponent( String component){
    this.component=component; return (T) this;
    }
    public String getHost(){
    return this.host;
    }
    public T withHost( String host){
    this.host=host; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
EventSourceFluent that = (EventSourceFluent) o;
if (component != null ? !component.equals(that.component) :that.component != null) return false;
if (host != null ? !host.equals(that.host) :that.host != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
