package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class NamedContextFluent<T extends NamedContextFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<Context, ?> context;     String name;     Map<String, Object> additionalProperties = new HashMap();

    public Context getContext(){
    return this.context!=null?this.context.build():null;
    }
    public T withContext( Context context){
    if (context!=null){ this.context= new ContextBuilder(context); _visitables.add(this.context);} return (T) this;
    }
    public ContextNested<T> withNewContext(){
    return new ContextNested<T>();
    }
    public ContextNested<T> withNewContextLike( Context item){
    return new ContextNested<T>(item);
    }
    public ContextNested<T> editContext(){
    return withNewContextLike(getContext());
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamedContextFluent that = (NamedContextFluent) o;
if (context != null ? !context.equals(that.context) :that.context != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ContextNested<N> extends ContextFluent<ContextNested<N>> implements Nested<N>{

        private final ContextBuilder builder;
    
             ContextNested (){
        this.builder = new ContextBuilder(this);
        }
             ContextNested ( Context item){
        this.builder = new ContextBuilder(this, item);
        }
    
            public N endContext(){
            return and();
        }
            public N and(){
            return (N) NamedContextFluent.this.withContext(builder.build());
        }
    
}


}
