package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class PreferencesFluent<T extends PreferencesFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Boolean colors;     List<VisitableBuilder<NamedExtension, ?>> extensions = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public Boolean isColors(){
    return this.colors;
    }
    public T withColors( Boolean colors){
    this.colors=colors; return (T) this;
    }
    public T addToExtensions( NamedExtension ...items){
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.add(builder);this.extensions.add(builder);} return (T)this;
    }
    public T removeFromExtensions( NamedExtension ...items){
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.remove(builder);this.extensions.remove(builder);} return (T)this;
    }
    public List<NamedExtension> getExtensions(){
    return build(extensions);
    }
    public T withExtensions( List<NamedExtension> extensions){
    this.extensions.clear();if (extensions != null) {for (NamedExtension item : extensions){this.addToExtensions(item);}} return (T) this;
    }
    public T withExtensions( NamedExtension ...extensions){
    this.extensions.clear(); if (extensions != null) {for (NamedExtension item :extensions){ this.addToExtensions(item);}} return (T) this;
    }
    public ExtensionsNested<T> addNewExtension(){
    return new ExtensionsNested<T>();
    }
    public ExtensionsNested<T> addNewExtensionLike( NamedExtension item){
    return new ExtensionsNested<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PreferencesFluent that = (PreferencesFluent) o;
if (colors != null ? !colors.equals(that.colors) :that.colors != null) return false;
if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ExtensionsNested<N> extends NamedExtensionFluent<ExtensionsNested<N>> implements Nested<N>{

        private final NamedExtensionBuilder builder;
    
             ExtensionsNested (){
        this.builder = new NamedExtensionBuilder(this);
        }
             ExtensionsNested ( NamedExtension item){
        this.builder = new NamedExtensionBuilder(this, item);
        }
    
            public N endExtension(){
            return and();
        }
            public N and(){
            return (N) PreferencesFluent.this.addToExtensions(builder.build());
        }
    
}


}
