package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class BuildStatusFluent<T extends BuildStatusFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Boolean cancelled;     String completionTimestamp;     VisitableBuilder<ObjectReference, ?> config;     Long duration;     String message;     String phase;     String startTimestamp;     Map<String, Object> additionalProperties = new HashMap();

    public Boolean isCancelled(){
    return this.cancelled;
    }
    public T withCancelled( Boolean cancelled){
    this.cancelled=cancelled; return (T) this;
    }
    public String getCompletionTimestamp(){
    return this.completionTimestamp;
    }
    public T withCompletionTimestamp( String completionTimestamp){
    this.completionTimestamp=completionTimestamp; return (T) this;
    }
    public ObjectReference getConfig(){
    return this.config!=null?this.config.build():null;
    }
    public T withConfig( ObjectReference config){
    if (config!=null){ this.config= new ObjectReferenceBuilder(config); _visitables.add(this.config);} return (T) this;
    }
    public ConfigNested<T> withNewConfig(){
    return new ConfigNested<T>();
    }
    public ConfigNested<T> withNewConfigLike( ObjectReference item){
    return new ConfigNested<T>(item);
    }
    public ConfigNested<T> editConfig(){
    return withNewConfigLike(getConfig());
    }
    public Long getDuration(){
    return this.duration;
    }
    public T withDuration( Long duration){
    this.duration=duration; return (T) this;
    }
    public String getMessage(){
    return this.message;
    }
    public T withMessage( String message){
    this.message=message; return (T) this;
    }
    public String getPhase(){
    return this.phase;
    }
    public T withPhase( String phase){
    this.phase=phase; return (T) this;
    }
    public String getStartTimestamp(){
    return this.startTimestamp;
    }
    public T withStartTimestamp( String startTimestamp){
    this.startTimestamp=startTimestamp; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildStatusFluent that = (BuildStatusFluent) o;
if (cancelled != null ? !cancelled.equals(that.cancelled) :that.cancelled != null) return false;
if (completionTimestamp != null ? !completionTimestamp.equals(that.completionTimestamp) :that.completionTimestamp != null) return false;
if (config != null ? !config.equals(that.config) :that.config != null) return false;
if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
if (message != null ? !message.equals(that.message) :that.message != null) return false;
if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
if (startTimestamp != null ? !startTimestamp.equals(that.startTimestamp) :that.startTimestamp != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ConfigNested<N> extends ObjectReferenceFluent<ConfigNested<N>> implements Nested<N>{

        private final ObjectReferenceBuilder builder;
    
             ConfigNested (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             ConfigNested ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N endConfig(){
            return and();
        }
            public N and(){
            return (N) BuildStatusFluent.this.withConfig(builder.build());
        }
    
}


}
