package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class PolicyRuleFluent<T extends PolicyRuleFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     HasMetadata attributeRestrictions;     List<String> nonResourceURLs = new ArrayList();     List<String> resourceNames = new ArrayList();     List<String> resources = new ArrayList();     List<String> verbs = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public HasMetadata getAttributeRestrictions(){
    return this.attributeRestrictions;
    }
    public T withAttributeRestrictions( HasMetadata attributeRestrictions){
    this.attributeRestrictions=attributeRestrictions; return (T) this;
    }
    public T addToNonResourceURLs( String ...items){
    for (String item : items) {this.nonResourceURLs.add(item);} return (T)this;
    }
    public T removeFromNonResourceURLs( String ...items){
    for (String item : items) {this.nonResourceURLs.remove(item);} return (T)this;
    }
    public List<String> getNonResourceURLs(){
    return this.nonResourceURLs;
    }
    public T withNonResourceURLs( List<String> nonResourceURLs){
    this.nonResourceURLs.clear();if (nonResourceURLs != null) {for (String item : nonResourceURLs){this.addToNonResourceURLs(item);}} return (T) this;
    }
    public T withNonResourceURLs( String ...nonResourceURLs){
    this.nonResourceURLs.clear(); if (nonResourceURLs != null) {for (String item :nonResourceURLs){ this.addToNonResourceURLs(item);}} return (T) this;
    }
    public T addToResourceNames( String ...items){
    for (String item : items) {this.resourceNames.add(item);} return (T)this;
    }
    public T removeFromResourceNames( String ...items){
    for (String item : items) {this.resourceNames.remove(item);} return (T)this;
    }
    public List<String> getResourceNames(){
    return this.resourceNames;
    }
    public T withResourceNames( List<String> resourceNames){
    this.resourceNames.clear();if (resourceNames != null) {for (String item : resourceNames){this.addToResourceNames(item);}} return (T) this;
    }
    public T withResourceNames( String ...resourceNames){
    this.resourceNames.clear(); if (resourceNames != null) {for (String item :resourceNames){ this.addToResourceNames(item);}} return (T) this;
    }
    public T addToResources( String ...items){
    for (String item : items) {this.resources.add(item);} return (T)this;
    }
    public T removeFromResources( String ...items){
    for (String item : items) {this.resources.remove(item);} return (T)this;
    }
    public List<String> getResources(){
    return this.resources;
    }
    public T withResources( List<String> resources){
    this.resources.clear();if (resources != null) {for (String item : resources){this.addToResources(item);}} return (T) this;
    }
    public T withResources( String ...resources){
    this.resources.clear(); if (resources != null) {for (String item :resources){ this.addToResources(item);}} return (T) this;
    }
    public T addToVerbs( String ...items){
    for (String item : items) {this.verbs.add(item);} return (T)this;
    }
    public T removeFromVerbs( String ...items){
    for (String item : items) {this.verbs.remove(item);} return (T)this;
    }
    public List<String> getVerbs(){
    return this.verbs;
    }
    public T withVerbs( List<String> verbs){
    this.verbs.clear();if (verbs != null) {for (String item : verbs){this.addToVerbs(item);}} return (T) this;
    }
    public T withVerbs( String ...verbs){
    this.verbs.clear(); if (verbs != null) {for (String item :verbs){ this.addToVerbs(item);}} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PolicyRuleFluent that = (PolicyRuleFluent) o;
if (attributeRestrictions != null ? !attributeRestrictions.equals(that.attributeRestrictions) :that.attributeRestrictions != null) return false;
if (nonResourceURLs != null ? !nonResourceURLs.equals(that.nonResourceURLs) :that.nonResourceURLs != null) return false;
if (resourceNames != null ? !resourceNames.equals(that.resourceNames) :that.resourceNames != null) return false;
if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
if (verbs != null ? !verbs.equals(that.verbs) :that.verbs != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
