package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.Template;
import java.util.Map;
import io.fabric8.openshift.api.model.RoleList;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.RoleBindingList;
import io.fabric8.openshift.api.model.PolicyBinding;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.TagEvent;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.Policy;
import io.fabric8.openshift.api.model.PolicyBindingList;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.ImageList;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.api.model.ClusterPolicyBinding;
import io.fabric8.openshift.api.model.ClusterPolicyList;
import io.fabric8.openshift.api.model.ClusterPolicy;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.UserList;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.IdentityList;
import java.util.HashMap;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationList;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthClientList;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.PolicyList;
import io.fabric8.openshift.api.model.GroupList;
import io.fabric8.openshift.api.model.ClusterPolicyBindingList;
import io.fabric8.openshift.api.model.Identity;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class KubeSchemaBuilder extends KubeSchemaFluent<KubeSchemaBuilder> implements VisitableBuilder<KubeSchema,KubeSchemaBuilder>{

     KubeSchemaFluent<?> fluent;
public KubeSchemaBuilder(){
    this(new KubeSchema());
}
public KubeSchemaBuilder( KubeSchemaFluent<?> fluent ){
    this(fluent, new KubeSchema());
}
public KubeSchemaBuilder( KubeSchemaFluent<?> fluent , KubeSchema instance ){
    this.fluent = fluent; fluent.withBaseKubernetesList(instance.getBaseKubernetesList()); fluent.withBuildConfigList(instance.getBuildConfigList()); fluent.withBuildList(instance.getBuildList()); fluent.withBuildRequest(instance.getBuildRequest()); fluent.withClusterPolicy(instance.getClusterPolicy()); fluent.withClusterPolicyBinding(instance.getClusterPolicyBinding()); fluent.withClusterPolicyBindingList(instance.getClusterPolicyBindingList()); fluent.withClusterPolicyList(instance.getClusterPolicyList()); fluent.withClusterRoleBinding(instance.getClusterRoleBinding()); fluent.withClusterRoleBindingList(instance.getClusterRoleBindingList()); fluent.withConfig(instance.getConfig()); fluent.withContainerStatus(instance.getContainerStatus()); fluent.withDeploymentConfigList(instance.getDeploymentConfigList()); fluent.withEndpoints(instance.getEndpoints()); fluent.withEndpointsList(instance.getEndpointsList()); fluent.withEnvVar(instance.getEnvVar()); fluent.withEventList(instance.getEventList()); fluent.withGroup(instance.getGroup()); fluent.withGroupList(instance.getGroupList()); fluent.withIdentity(instance.getIdentity()); fluent.withIdentityList(instance.getIdentityList()); fluent.withImageList(instance.getImageList()); fluent.withImageStreamList(instance.getImageStreamList()); fluent.withNamespace(instance.getNamespace()); fluent.withNamespaceList(instance.getNamespaceList()); fluent.withNode(instance.getNode()); fluent.withNodeList(instance.getNodeList()); fluent.withOAuthAccessToken(instance.getOAuthAccessToken()); fluent.withOAuthAccessTokenList(instance.getOAuthAccessTokenList()); fluent.withOAuthAuthorizeToken(instance.getOAuthAuthorizeToken()); fluent.withOAuthAuthorizeTokenList(instance.getOAuthAuthorizeTokenList()); fluent.withOAuthClient(instance.getOAuthClient()); fluent.withOAuthClientAuthorization(instance.getOAuthClientAuthorization()); fluent.withOAuthClientAuthorizationList(instance.getOAuthClientAuthorizationList()); fluent.withOAuthClientList(instance.getOAuthClientList()); fluent.withObjectMeta(instance.getObjectMeta()); fluent.withPersistentVolume(instance.getPersistentVolume()); fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); fluent.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList()); fluent.withPersistentVolumeList(instance.getPersistentVolumeList()); fluent.withPodList(instance.getPodList()); fluent.withPolicy(instance.getPolicy()); fluent.withPolicyBinding(instance.getPolicyBinding()); fluent.withPolicyBindingList(instance.getPolicyBindingList()); fluent.withPolicyList(instance.getPolicyList()); fluent.withQuantity(instance.getQuantity()); fluent.withReplicationControllerList(instance.getReplicationControllerList()); fluent.withResourceQuota(instance.getResourceQuota()); fluent.withResourceQuotaList(instance.getResourceQuotaList()); fluent.withRole(instance.getRole()); fluent.withRoleBinding(instance.getRoleBinding()); fluent.withRoleBindingList(instance.getRoleBindingList()); fluent.withRoleList(instance.getRoleList()); fluent.withRootPaths(instance.getRootPaths()); fluent.withRouteList(instance.getRouteList()); fluent.withSecret(instance.getSecret()); fluent.withSecretList(instance.getSecretList()); fluent.withSecurityContextConstraints(instance.getSecurityContextConstraints()); fluent.withSecurityContextConstraintsList(instance.getSecurityContextConstraintsList()); fluent.withServiceAccount(instance.getServiceAccount()); fluent.withServiceAccountList(instance.getServiceAccountList()); fluent.withServiceList(instance.getServiceList()); fluent.withStatus(instance.getStatus()); fluent.withTagEvent(instance.getTagEvent()); fluent.withTemplate(instance.getTemplate()); fluent.withTemplateList(instance.getTemplateList()); fluent.withUser(instance.getUser()); fluent.withUserList(instance.getUserList()); fluent.withWatchEvent(instance.getWatchEvent()); 
}
public KubeSchemaBuilder( KubeSchema instance ){
    this.fluent = this; this.withBaseKubernetesList(instance.getBaseKubernetesList()); this.withBuildConfigList(instance.getBuildConfigList()); this.withBuildList(instance.getBuildList()); this.withBuildRequest(instance.getBuildRequest()); this.withClusterPolicy(instance.getClusterPolicy()); this.withClusterPolicyBinding(instance.getClusterPolicyBinding()); this.withClusterPolicyBindingList(instance.getClusterPolicyBindingList()); this.withClusterPolicyList(instance.getClusterPolicyList()); this.withClusterRoleBinding(instance.getClusterRoleBinding()); this.withClusterRoleBindingList(instance.getClusterRoleBindingList()); this.withConfig(instance.getConfig()); this.withContainerStatus(instance.getContainerStatus()); this.withDeploymentConfigList(instance.getDeploymentConfigList()); this.withEndpoints(instance.getEndpoints()); this.withEndpointsList(instance.getEndpointsList()); this.withEnvVar(instance.getEnvVar()); this.withEventList(instance.getEventList()); this.withGroup(instance.getGroup()); this.withGroupList(instance.getGroupList()); this.withIdentity(instance.getIdentity()); this.withIdentityList(instance.getIdentityList()); this.withImageList(instance.getImageList()); this.withImageStreamList(instance.getImageStreamList()); this.withNamespace(instance.getNamespace()); this.withNamespaceList(instance.getNamespaceList()); this.withNode(instance.getNode()); this.withNodeList(instance.getNodeList()); this.withOAuthAccessToken(instance.getOAuthAccessToken()); this.withOAuthAccessTokenList(instance.getOAuthAccessTokenList()); this.withOAuthAuthorizeToken(instance.getOAuthAuthorizeToken()); this.withOAuthAuthorizeTokenList(instance.getOAuthAuthorizeTokenList()); this.withOAuthClient(instance.getOAuthClient()); this.withOAuthClientAuthorization(instance.getOAuthClientAuthorization()); this.withOAuthClientAuthorizationList(instance.getOAuthClientAuthorizationList()); this.withOAuthClientList(instance.getOAuthClientList()); this.withObjectMeta(instance.getObjectMeta()); this.withPersistentVolume(instance.getPersistentVolume()); this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); this.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList()); this.withPersistentVolumeList(instance.getPersistentVolumeList()); this.withPodList(instance.getPodList()); this.withPolicy(instance.getPolicy()); this.withPolicyBinding(instance.getPolicyBinding()); this.withPolicyBindingList(instance.getPolicyBindingList()); this.withPolicyList(instance.getPolicyList()); this.withQuantity(instance.getQuantity()); this.withReplicationControllerList(instance.getReplicationControllerList()); this.withResourceQuota(instance.getResourceQuota()); this.withResourceQuotaList(instance.getResourceQuotaList()); this.withRole(instance.getRole()); this.withRoleBinding(instance.getRoleBinding()); this.withRoleBindingList(instance.getRoleBindingList()); this.withRoleList(instance.getRoleList()); this.withRootPaths(instance.getRootPaths()); this.withRouteList(instance.getRouteList()); this.withSecret(instance.getSecret()); this.withSecretList(instance.getSecretList()); this.withSecurityContextConstraints(instance.getSecurityContextConstraints()); this.withSecurityContextConstraintsList(instance.getSecurityContextConstraintsList()); this.withServiceAccount(instance.getServiceAccount()); this.withServiceAccountList(instance.getServiceAccountList()); this.withServiceList(instance.getServiceList()); this.withStatus(instance.getStatus()); this.withTagEvent(instance.getTagEvent()); this.withTemplate(instance.getTemplate()); this.withTemplateList(instance.getTemplateList()); this.withUser(instance.getUser()); this.withUserList(instance.getUserList()); this.withWatchEvent(instance.getWatchEvent()); 
}

public EditableKubeSchema build(){
    EditableKubeSchema buildable = new EditableKubeSchema(fluent.getBaseKubernetesList(),fluent.getBuildConfigList(),fluent.getBuildList(),fluent.getBuildRequest(),fluent.getClusterPolicy(),fluent.getClusterPolicyBinding(),fluent.getClusterPolicyBindingList(),fluent.getClusterPolicyList(),fluent.getClusterRoleBinding(),fluent.getClusterRoleBindingList(),fluent.getConfig(),fluent.getContainerStatus(),fluent.getDeploymentConfigList(),fluent.getEndpoints(),fluent.getEndpointsList(),fluent.getEnvVar(),fluent.getEventList(),fluent.getGroup(),fluent.getGroupList(),fluent.getIdentity(),fluent.getIdentityList(),fluent.getImageList(),fluent.getImageStreamList(),fluent.getNamespace(),fluent.getNamespaceList(),fluent.getNode(),fluent.getNodeList(),fluent.getOAuthAccessToken(),fluent.getOAuthAccessTokenList(),fluent.getOAuthAuthorizeToken(),fluent.getOAuthAuthorizeTokenList(),fluent.getOAuthClient(),fluent.getOAuthClientAuthorization(),fluent.getOAuthClientAuthorizationList(),fluent.getOAuthClientList(),fluent.getObjectMeta(),fluent.getPersistentVolume(),fluent.getPersistentVolumeClaim(),fluent.getPersistentVolumeClaimList(),fluent.getPersistentVolumeList(),fluent.getPodList(),fluent.getPolicy(),fluent.getPolicyBinding(),fluent.getPolicyBindingList(),fluent.getPolicyList(),fluent.getQuantity(),fluent.getReplicationControllerList(),fluent.getResourceQuota(),fluent.getResourceQuotaList(),fluent.getRole(),fluent.getRoleBinding(),fluent.getRoleBindingList(),fluent.getRoleList(),fluent.getRootPaths(),fluent.getRouteList(),fluent.getSecret(),fluent.getSecretList(),fluent.getSecurityContextConstraints(),fluent.getSecurityContextConstraintsList(),fluent.getServiceAccount(),fluent.getServiceAccountList(),fluent.getServiceList(),fluent.getStatus(),fluent.getTagEvent(),fluent.getTemplate(),fluent.getTemplateList(),fluent.getUser(),fluent.getUserList(),fluent.getWatchEvent());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
KubeSchemaBuilder that = (KubeSchemaBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    