/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputBuilder;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildSourceBuilder;
import io.fabric8.openshift.api.model.BuildSourceFluent;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.BuildTriggerPolicy;
import io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder;
import io.fabric8.openshift.api.model.BuildTriggerPolicyFluent;
import io.fabric8.openshift.api.model.SourceRevision;
import io.fabric8.openshift.api.model.SourceRevisionBuilder;
import io.fabric8.openshift.api.model.SourceRevisionFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildConfigSpecFluent<T extends BuildConfigSpecFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    VisitableBuilder<BuildOutput, ?> output;
    VisitableBuilder<ResourceRequirements, ?> resources;
    VisitableBuilder<SourceRevision, ?> revision;
    String serviceAccount;
    VisitableBuilder<BuildSource, ?> source;
    VisitableBuilder<BuildStrategy, ?> strategy;
    List<VisitableBuilder<BuildTriggerPolicy, ?>> triggers = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BuildOutput getOutput() {
        return this.output != null ? (BuildOutput)this.output.build() : null;
    }

    public T withOutput(BuildOutput output) {
        if (output != null) {
            this.output = new BuildOutputBuilder(output);
            this._visitables.add(this.output);
        }
        return (T)this;
    }

    public OutputNested<T> withNewOutput() {
        return new OutputNested();
    }

    public OutputNested<T> withNewOutputLike(BuildOutput item) {
        return new OutputNested(item);
    }

    public OutputNested<T> editOutput() {
        return this.withNewOutputLike(this.getOutput());
    }

    public ResourceRequirements getResources() {
        return this.resources != null ? (ResourceRequirements)this.resources.build() : null;
    }

    public T withResources(ResourceRequirements resources) {
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (T)this;
    }

    public ResourcesNested<T> withNewResources() {
        return new ResourcesNested();
    }

    public ResourcesNested<T> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<T> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    public SourceRevision getRevision() {
        return this.revision != null ? (SourceRevision)this.revision.build() : null;
    }

    public T withRevision(SourceRevision revision) {
        if (revision != null) {
            this.revision = new SourceRevisionBuilder(revision);
            this._visitables.add(this.revision);
        }
        return (T)this;
    }

    public RevisionNested<T> withNewRevision() {
        return new RevisionNested();
    }

    public RevisionNested<T> withNewRevisionLike(SourceRevision item) {
        return new RevisionNested(item);
    }

    public RevisionNested<T> editRevision() {
        return this.withNewRevisionLike(this.getRevision());
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public T withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (T)this;
    }

    public BuildSource getSource() {
        return this.source != null ? (BuildSource)this.source.build() : null;
    }

    public T withSource(BuildSource source) {
        if (source != null) {
            this.source = new BuildSourceBuilder(source);
            this._visitables.add(this.source);
        }
        return (T)this;
    }

    public SourceNested<T> withNewSource() {
        return new SourceNested();
    }

    public SourceNested<T> withNewSourceLike(BuildSource item) {
        return new SourceNested(item);
    }

    public SourceNested<T> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    public BuildStrategy getStrategy() {
        return this.strategy != null ? (BuildStrategy)this.strategy.build() : null;
    }

    public T withStrategy(BuildStrategy strategy) {
        if (strategy != null) {
            this.strategy = new BuildStrategyBuilder(strategy);
            this._visitables.add(this.strategy);
        }
        return (T)this;
    }

    public StrategyNested<T> withNewStrategy() {
        return new StrategyNested();
    }

    public StrategyNested<T> withNewStrategyLike(BuildStrategy item) {
        return new StrategyNested(item);
    }

    public StrategyNested<T> editStrategy() {
        return this.withNewStrategyLike(this.getStrategy());
    }

    public T addToTriggers(BuildTriggerPolicy ... items) {
        for (BuildTriggerPolicy item : items) {
            BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
            this._visitables.add(builder);
            this.triggers.add(builder);
        }
        return (T)this;
    }

    public T removeFromTriggers(BuildTriggerPolicy ... items) {
        for (BuildTriggerPolicy item : items) {
            BuildTriggerPolicyBuilder builder = new BuildTriggerPolicyBuilder(item);
            this._visitables.remove(builder);
            this.triggers.remove(builder);
        }
        return (T)this;
    }

    public List<BuildTriggerPolicy> getTriggers() {
        return this.build(this.triggers);
    }

    public T withTriggers(List<BuildTriggerPolicy> triggers) {
        this.triggers.clear();
        if (triggers != null) {
            for (BuildTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (T)this;
    }

    public T withTriggers(BuildTriggerPolicy ... triggers) {
        this.triggers.clear();
        if (triggers != null) {
            for (BuildTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (T)this;
    }

    public TriggersNested<T> addNewTrigger() {
        return new TriggersNested();
    }

    public TriggersNested<T> addNewTriggerLike(BuildTriggerPolicy item) {
        return new TriggersNested(item);
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildConfigSpecFluent that = (BuildConfigSpecFluent)o;
        if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        if (this.triggers != null ? !this.triggers.equals(that.triggers) : that.triggers != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class TriggersNested<N>
    extends BuildTriggerPolicyFluent<TriggersNested<N>>
    implements Nested<N> {
        private final BuildTriggerPolicyBuilder builder;

        TriggersNested() {
            this.builder = new BuildTriggerPolicyBuilder(this);
        }

        TriggersNested(BuildTriggerPolicy item) {
            this.builder = new BuildTriggerPolicyBuilder(this, item);
        }

        public N endTrigger() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluent.this.addToTriggers(this.builder.build());
        }
    }

    public class StrategyNested<N>
    extends BuildStrategyFluent<StrategyNested<N>>
    implements Nested<N> {
        private final BuildStrategyBuilder builder;

        StrategyNested(BuildStrategy item) {
            this.builder = new BuildStrategyBuilder(this, item);
        }

        StrategyNested() {
            this.builder = new BuildStrategyBuilder(this);
        }

        public N endStrategy() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluent.this.withStrategy(this.builder.build());
        }
    }

    public class SourceNested<N>
    extends BuildSourceFluent<SourceNested<N>>
    implements Nested<N> {
        private final BuildSourceBuilder builder;

        SourceNested() {
            this.builder = new BuildSourceBuilder(this);
        }

        SourceNested(BuildSource item) {
            this.builder = new BuildSourceBuilder(this, item);
        }

        public N endSource() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluent.this.withSource(this.builder.build());
        }
    }

    public class RevisionNested<N>
    extends SourceRevisionFluent<RevisionNested<N>>
    implements Nested<N> {
        private final SourceRevisionBuilder builder;

        RevisionNested() {
            this.builder = new SourceRevisionBuilder(this);
        }

        RevisionNested(SourceRevision item) {
            this.builder = new SourceRevisionBuilder(this, item);
        }

        public N endRevision() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluent.this.withRevision(this.builder.build());
        }
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNested() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        public N endResources() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluent.this.withResources(this.builder.build());
        }
    }

    public class OutputNested<N>
    extends BuildOutputFluent<OutputNested<N>>
    implements Nested<N> {
        private final BuildOutputBuilder builder;

        OutputNested() {
            this.builder = new BuildOutputBuilder(this);
        }

        OutputNested(BuildOutput item) {
            this.builder = new BuildOutputBuilder(this, item);
        }

        public N endOutput() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildConfigSpecFluent.this.withOutput(this.builder.build());
        }
    }
}

