/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.NamedRole;
import io.fabric8.openshift.api.model.NamedRoleBuilder;
import io.fabric8.openshift.api.model.NamedRoleFluent;
import io.fabric8.openshift.api.model.Policy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PolicyFluent<T extends PolicyFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Policy.ApiVersion apiVersion;
    String kind;
    String lastModified;
    VisitableBuilder<ObjectMeta, ?> metadata;
    List<VisitableBuilder<NamedRole, ?>> roles = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Policy.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(Policy.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public T withLastModified(String lastModified) {
        this.lastModified = lastModified;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public T addToRoles(NamedRole ... items) {
        for (NamedRole item : items) {
            NamedRoleBuilder builder = new NamedRoleBuilder(item);
            this._visitables.add(builder);
            this.roles.add(builder);
        }
        return (T)this;
    }

    public T removeFromRoles(NamedRole ... items) {
        for (NamedRole item : items) {
            NamedRoleBuilder builder = new NamedRoleBuilder(item);
            this._visitables.remove(builder);
            this.roles.remove(builder);
        }
        return (T)this;
    }

    public List<NamedRole> getRoles() {
        return this.build(this.roles);
    }

    public T withRoles(List<NamedRole> roles) {
        this.roles.clear();
        if (roles != null) {
            for (NamedRole item : roles) {
                this.addToRoles(item);
            }
        }
        return (T)this;
    }

    public T withRoles(NamedRole ... roles) {
        this.roles.clear();
        if (roles != null) {
            for (NamedRole item : roles) {
                this.addToRoles(item);
            }
        }
        return (T)this;
    }

    public RolesNested<T> addNewRole() {
        return new RolesNested();
    }

    public RolesNested<T> addNewRoleLike(NamedRole item) {
        return new RolesNested(item);
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyFluent that = (PolicyFluent)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastModified != null ? !this.lastModified.equals(that.lastModified) : that.lastModified != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.roles != null ? !this.roles.equals(that.roles) : that.roles != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class RolesNested<N>
    extends NamedRoleFluent<RolesNested<N>>
    implements Nested<N> {
        private final NamedRoleBuilder builder;

        RolesNested() {
            this.builder = new NamedRoleBuilder(this);
        }

        RolesNested(NamedRole item) {
            this.builder = new NamedRoleBuilder(this, item);
        }

        public N endRole() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PolicyFluent.this.addToRoles(this.builder.build());
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        public N endMetadata() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PolicyFluent.this.withMetadata(this.builder.build());
        }
    }
}

