package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class RunAsUserStrategyOptionsBuilder extends RunAsUserStrategyOptionsFluent<RunAsUserStrategyOptionsBuilder> implements VisitableBuilder<RunAsUserStrategyOptions,RunAsUserStrategyOptionsBuilder>{

     RunAsUserStrategyOptionsFluent<?> fluent;
public RunAsUserStrategyOptionsBuilder(){
    this(new RunAsUserStrategyOptions());
}
public RunAsUserStrategyOptionsBuilder( RunAsUserStrategyOptionsFluent<?> fluent ){
    this(fluent, new RunAsUserStrategyOptions());
}
public RunAsUserStrategyOptionsBuilder( RunAsUserStrategyOptionsFluent<?> fluent , RunAsUserStrategyOptions instance ){
    this.fluent = fluent; fluent.withType(instance.getType()); fluent.withUid(instance.getUid()); fluent.withUidRangeMax(instance.getUidRangeMax()); fluent.withUidRangeMin(instance.getUidRangeMin()); 
}
public RunAsUserStrategyOptionsBuilder( RunAsUserStrategyOptions instance ){
    this.fluent = this; this.withType(instance.getType()); this.withUid(instance.getUid()); this.withUidRangeMax(instance.getUidRangeMax()); this.withUidRangeMin(instance.getUidRangeMin()); 
}

public EditableRunAsUserStrategyOptions build(){
    EditableRunAsUserStrategyOptions buildable = new EditableRunAsUserStrategyOptions(fluent.getType(),fluent.getUid(),fluent.getUidRangeMax(),fluent.getUidRangeMin());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
RunAsUserStrategyOptionsBuilder that = (RunAsUserStrategyOptionsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    