
package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "lastModified",
    "metadata",
    "policyRef",
    "roleBindings"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class ClusterPolicyBinding implements HasMetadata
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("apiVersion")
    @NotNull
    private ClusterPolicyBinding.ApiVersion apiVersion = ClusterPolicyBinding.ApiVersion.fromValue("v1");
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("kind")
    @NotNull
    private String kind = "ClusterPolicyBinding";
    /**
     * last time any part of the object was created
     * 
     */
    @JsonProperty("lastModified")
    private String lastModified;
    /**
     * 
     * 
     */
    @JsonProperty("metadata")
    @Valid
    private ObjectMeta metadata;
    /**
     * 
     * 
     */
    @JsonProperty("policyRef")
    @Valid
    private ObjectReference policyRef;
    /**
     * all the role bindings held by this policy
     * 
     */
    @JsonProperty("roleBindings")
    @Valid
    private List<NamedClusterRoleBinding> roleBindings = new ArrayList<NamedClusterRoleBinding>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ClusterPolicyBinding() {
    }

    /**
     * 
     * @param roleBindings
     * @param metadata
     * @param apiVersion
     * @param kind
     * @param lastModified
     * @param policyRef
     */
    public ClusterPolicyBinding(ClusterPolicyBinding.ApiVersion apiVersion, String kind, String lastModified, ObjectMeta metadata, ObjectReference policyRef, List<NamedClusterRoleBinding> roleBindings) {
        this.apiVersion = apiVersion;
        this.kind = kind;
        this.lastModified = lastModified;
        this.metadata = metadata;
        this.policyRef = policyRef;
        this.roleBindings = roleBindings;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public ClusterPolicyBinding.ApiVersion getApiVersion() {
        return apiVersion;
    }

    /**
     * 
     * (Required)
     * 
     * @param apiVersion
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public void setApiVersion(ClusterPolicyBinding.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The kind
     */
    @JsonProperty("kind")
    public String getKind() {
        return kind;
    }

    /**
     * 
     * (Required)
     * 
     * @param kind
     *     The kind
     */
    @JsonProperty("kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    /**
     * last time any part of the object was created
     * 
     * @return
     *     The lastModified
     */
    @JsonProperty("lastModified")
    public String getLastModified() {
        return lastModified;
    }

    /**
     * last time any part of the object was created
     * 
     * @param lastModified
     *     The lastModified
     */
    @JsonProperty("lastModified")
    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    /**
     * 
     * 
     * @return
     *     The metadata
     */
    @JsonProperty("metadata")
    public ObjectMeta getMetadata() {
        return metadata;
    }

    /**
     * 
     * 
     * @param metadata
     *     The metadata
     */
    @JsonProperty("metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    /**
     * 
     * 
     * @return
     *     The policyRef
     */
    @JsonProperty("policyRef")
    public ObjectReference getPolicyRef() {
        return policyRef;
    }

    /**
     * 
     * 
     * @param policyRef
     *     The policyRef
     */
    @JsonProperty("policyRef")
    public void setPolicyRef(ObjectReference policyRef) {
        this.policyRef = policyRef;
    }

    /**
     * all the role bindings held by this policy
     * 
     * @return
     *     The roleBindings
     */
    @JsonProperty("roleBindings")
    public List<NamedClusterRoleBinding> getRoleBindings() {
        return roleBindings;
    }

    /**
     * all the role bindings held by this policy
     * 
     * @param roleBindings
     *     The roleBindings
     */
    @JsonProperty("roleBindings")
    public void setRoleBindings(List<NamedClusterRoleBinding> roleBindings) {
        this.roleBindings = roleBindings;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Generated("org.jsonschema2pojo")
    public static enum ApiVersion {

        V_1("v1");
        private final String value;
        private static Map<String, ClusterPolicyBinding.ApiVersion> constants = new HashMap<String, ClusterPolicyBinding.ApiVersion>();

        static {
            for (ClusterPolicyBinding.ApiVersion c: values()) {
                constants.put(c.value, c);
            }
        }

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ClusterPolicyBinding.ApiVersion fromValue(String value) {
            ClusterPolicyBinding.ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
