package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class RollingDeploymentStrategyParamsFluent<T extends RollingDeploymentStrategyParamsFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Long intervalSeconds;     VisitableBuilder<LifecycleHook, ?> post;     VisitableBuilder<LifecycleHook, ?> pre;     Long timeoutSeconds;     Integer updatePercent;     Long updatePeriodSeconds;     Map<String, Object> additionalProperties = new HashMap();

    public Long getIntervalSeconds(){
    return this.intervalSeconds;
    }
    public T withIntervalSeconds( Long intervalSeconds){
    this.intervalSeconds=intervalSeconds; return (T) this;
    }
    public LifecycleHook getPost(){
    return this.post!=null?this.post.build():null;
    }
    public T withPost( LifecycleHook post){
    if (post!=null){ this.post= new LifecycleHookBuilder(post); _visitables.add(this.post);} return (T) this;
    }
    public PostNested<T> withNewPost(){
    return new PostNested<T>();
    }
    public PostNested<T> withNewPostLike( LifecycleHook item){
    return new PostNested<T>(item);
    }
    public PostNested<T> editPost(){
    return withNewPostLike(getPost());
    }
    public LifecycleHook getPre(){
    return this.pre!=null?this.pre.build():null;
    }
    public T withPre( LifecycleHook pre){
    if (pre!=null){ this.pre= new LifecycleHookBuilder(pre); _visitables.add(this.pre);} return (T) this;
    }
    public PreNested<T> withNewPre(){
    return new PreNested<T>();
    }
    public PreNested<T> withNewPreLike( LifecycleHook item){
    return new PreNested<T>(item);
    }
    public PreNested<T> editPre(){
    return withNewPreLike(getPre());
    }
    public Long getTimeoutSeconds(){
    return this.timeoutSeconds;
    }
    public T withTimeoutSeconds( Long timeoutSeconds){
    this.timeoutSeconds=timeoutSeconds; return (T) this;
    }
    public Integer getUpdatePercent(){
    return this.updatePercent;
    }
    public T withUpdatePercent( Integer updatePercent){
    this.updatePercent=updatePercent; return (T) this;
    }
    public Long getUpdatePeriodSeconds(){
    return this.updatePeriodSeconds;
    }
    public T withUpdatePeriodSeconds( Long updatePeriodSeconds){
    this.updatePeriodSeconds=updatePeriodSeconds; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RollingDeploymentStrategyParamsFluent that = (RollingDeploymentStrategyParamsFluent) o;
if (intervalSeconds != null ? !intervalSeconds.equals(that.intervalSeconds) :that.intervalSeconds != null) return false;
if (post != null ? !post.equals(that.post) :that.post != null) return false;
if (pre != null ? !pre.equals(that.pre) :that.pre != null) return false;
if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
if (updatePercent != null ? !updatePercent.equals(that.updatePercent) :that.updatePercent != null) return false;
if (updatePeriodSeconds != null ? !updatePeriodSeconds.equals(that.updatePeriodSeconds) :that.updatePeriodSeconds != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class PostNested<N> extends LifecycleHookFluent<PostNested<N>> implements Nested<N>{

        private final LifecycleHookBuilder builder;
    
             PostNested ( LifecycleHook item){
        this.builder = new LifecycleHookBuilder(this, item);
        }
             PostNested (){
        this.builder = new LifecycleHookBuilder(this);
        }
    
            public N endPost(){
            return and();
        }
            public N and(){
            return (N) RollingDeploymentStrategyParamsFluent.this.withPost(builder.build());
        }
    
}
    public class PreNested<N> extends LifecycleHookFluent<PreNested<N>> implements Nested<N>{

        private final LifecycleHookBuilder builder;
    
             PreNested (){
        this.builder = new LifecycleHookBuilder(this);
        }
             PreNested ( LifecycleHook item){
        this.builder = new LifecycleHookBuilder(this, item);
        }
    
            public N and(){
            return (N) RollingDeploymentStrategyParamsFluent.this.withPre(builder.build());
        }
            public N endPre(){
            return and();
        }
    
}


}
