/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableNodeStatus;
import io.fabric8.kubernetes.api.model.NodeStatus;
import io.fabric8.kubernetes.api.model.NodeStatusFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NodeStatusBuilder
extends NodeStatusFluent<NodeStatusBuilder>
implements VisitableBuilder<NodeStatus, NodeStatusBuilder> {
    NodeStatusFluent<?> fluent;

    public NodeStatusBuilder() {
        this(new NodeStatus());
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent) {
        this(fluent, new NodeStatus());
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent, NodeStatus instance) {
        this.fluent = fluent;
        fluent.withAddresses(instance.getAddresses());
        fluent.withCapacity(instance.getCapacity());
        fluent.withConditions(instance.getConditions());
        fluent.withNodeInfo(instance.getNodeInfo());
        fluent.withPhase(instance.getPhase());
    }

    public NodeStatusBuilder(NodeStatus instance) {
        this.fluent = this;
        this.withAddresses(instance.getAddresses());
        this.withCapacity(instance.getCapacity());
        this.withConditions(instance.getConditions());
        this.withNodeInfo(instance.getNodeInfo());
        this.withPhase(instance.getPhase());
    }

    @Override
    public EditableNodeStatus build() {
        EditableNodeStatus buildable = new EditableNodeStatus(this.fluent.getAddresses(), this.fluent.getCapacity(), this.fluent.getConditions(), this.fluent.getNodeInfo(), this.fluent.getPhase());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeStatusBuilder that = (NodeStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

