
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "intervalSeconds",
    "post",
    "pre",
    "timeoutSeconds",
    "updatePercent",
    "updatePeriodSeconds"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class RollingDeploymentStrategyParams {

    /**
     * the time to wait between polling deployment status after update
     * 
     */
    @JsonProperty("intervalSeconds")
    private Long intervalSeconds;
    /**
     * 
     * 
     */
    @JsonProperty("post")
    @Valid
    private LifecycleHook post;
    /**
     * 
     * 
     */
    @JsonProperty("pre")
    @Valid
    private LifecycleHook pre;
    /**
     * the time to wait for updates before giving up
     * 
     */
    @JsonProperty("timeoutSeconds")
    private Long timeoutSeconds;
    /**
     * the percentage of replicas to scale up or down each interval (negative value switches scale order to down/up instead of up/down)
     * 
     */
    @JsonProperty("updatePercent")
    private Integer updatePercent;
    /**
     * the time to wait between individual pod updates
     * 
     */
    @JsonProperty("updatePeriodSeconds")
    private Long updatePeriodSeconds;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public RollingDeploymentStrategyParams() {
    }

    /**
     * 
     * @param updatePercent
     * @param updatePeriodSeconds
     * @param pre
     * @param post
     * @param timeoutSeconds
     * @param intervalSeconds
     */
    public RollingDeploymentStrategyParams(Long intervalSeconds, LifecycleHook post, LifecycleHook pre, Long timeoutSeconds, Integer updatePercent, Long updatePeriodSeconds) {
        this.intervalSeconds = intervalSeconds;
        this.post = post;
        this.pre = pre;
        this.timeoutSeconds = timeoutSeconds;
        this.updatePercent = updatePercent;
        this.updatePeriodSeconds = updatePeriodSeconds;
    }

    /**
     * the time to wait between polling deployment status after update
     * 
     * @return
     *     The intervalSeconds
     */
    @JsonProperty("intervalSeconds")
    public Long getIntervalSeconds() {
        return intervalSeconds;
    }

    /**
     * the time to wait between polling deployment status after update
     * 
     * @param intervalSeconds
     *     The intervalSeconds
     */
    @JsonProperty("intervalSeconds")
    public void setIntervalSeconds(Long intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
    }

    /**
     * 
     * 
     * @return
     *     The post
     */
    @JsonProperty("post")
    public LifecycleHook getPost() {
        return post;
    }

    /**
     * 
     * 
     * @param post
     *     The post
     */
    @JsonProperty("post")
    public void setPost(LifecycleHook post) {
        this.post = post;
    }

    /**
     * 
     * 
     * @return
     *     The pre
     */
    @JsonProperty("pre")
    public LifecycleHook getPre() {
        return pre;
    }

    /**
     * 
     * 
     * @param pre
     *     The pre
     */
    @JsonProperty("pre")
    public void setPre(LifecycleHook pre) {
        this.pre = pre;
    }

    /**
     * the time to wait for updates before giving up
     * 
     * @return
     *     The timeoutSeconds
     */
    @JsonProperty("timeoutSeconds")
    public Long getTimeoutSeconds() {
        return timeoutSeconds;
    }

    /**
     * the time to wait for updates before giving up
     * 
     * @param timeoutSeconds
     *     The timeoutSeconds
     */
    @JsonProperty("timeoutSeconds")
    public void setTimeoutSeconds(Long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    /**
     * the percentage of replicas to scale up or down each interval (negative value switches scale order to down/up instead of up/down)
     * 
     * @return
     *     The updatePercent
     */
    @JsonProperty("updatePercent")
    public Integer getUpdatePercent() {
        return updatePercent;
    }

    /**
     * the percentage of replicas to scale up or down each interval (negative value switches scale order to down/up instead of up/down)
     * 
     * @param updatePercent
     *     The updatePercent
     */
    @JsonProperty("updatePercent")
    public void setUpdatePercent(Integer updatePercent) {
        this.updatePercent = updatePercent;
    }

    /**
     * the time to wait between individual pod updates
     * 
     * @return
     *     The updatePeriodSeconds
     */
    @JsonProperty("updatePeriodSeconds")
    public Long getUpdatePeriodSeconds() {
        return updatePeriodSeconds;
    }

    /**
     * the time to wait between individual pod updates
     * 
     * @param updatePeriodSeconds
     *     The updatePeriodSeconds
     */
    @JsonProperty("updatePeriodSeconds")
    public void setUpdatePeriodSeconds(Long updatePeriodSeconds) {
        this.updatePeriodSeconds = updatePeriodSeconds;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
