/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.ContainerStatusBuilder;
import io.fabric8.kubernetes.api.model.ContainerStatusFluent;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodConditionBuilder;
import io.fabric8.kubernetes.api.model.PodConditionFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PodStatusFluent<T extends PodStatusFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    List<VisitableBuilder<PodCondition, ?>> conditions = new ArrayList();
    List<VisitableBuilder<ContainerStatus, ?>> containerStatuses = new ArrayList();
    String hostIP;
    String message;
    String phase;
    String podIP;
    String reason;
    String startTime;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public T addToConditions(PodCondition ... items) {
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (T)this;
    }

    public T removeFromConditions(PodCondition ... items) {
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (T)this;
    }

    public List<PodCondition> getConditions() {
        return this.build(this.conditions);
    }

    public T withConditions(List<PodCondition> conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (PodCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (T)this;
    }

    public T withConditions(PodCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (PodCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (T)this;
    }

    public ConditionsNested<T> addNewCondition() {
        return new ConditionsNested();
    }

    public ConditionsNested<T> addNewConditionLike(PodCondition item) {
        return new ConditionsNested(item);
    }

    public T addNewCondition(String status, String type) {
        return this.addToConditions(new PodCondition(status, type));
    }

    public T addToContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.add(builder);
            this.containerStatuses.add(builder);
        }
        return (T)this;
    }

    public T removeFromContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.remove(builder);
            this.containerStatuses.remove(builder);
        }
        return (T)this;
    }

    public List<ContainerStatus> getContainerStatuses() {
        return this.build(this.containerStatuses);
    }

    public T withContainerStatuses(List<ContainerStatus> containerStatuses) {
        this.containerStatuses.clear();
        if (containerStatuses != null) {
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (T)this;
    }

    public T withContainerStatuses(ContainerStatus ... containerStatuses) {
        this.containerStatuses.clear();
        if (containerStatuses != null) {
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (T)this;
    }

    public ContainerStatusesNested<T> addNewContainerStatuse() {
        return new ContainerStatusesNested();
    }

    public ContainerStatusesNested<T> addNewContainerStatuseLike(ContainerStatus item) {
        return new ContainerStatusesNested(item);
    }

    public String getHostIP() {
        return this.hostIP;
    }

    public T withHostIP(String hostIP) {
        this.hostIP = hostIP;
        return (T)this;
    }

    public String getMessage() {
        return this.message;
    }

    public T withMessage(String message) {
        this.message = message;
        return (T)this;
    }

    public String getPhase() {
        return this.phase;
    }

    public T withPhase(String phase) {
        this.phase = phase;
        return (T)this;
    }

    public String getPodIP() {
        return this.podIP;
    }

    public T withPodIP(String podIP) {
        this.podIP = podIP;
        return (T)this;
    }

    public String getReason() {
        return this.reason;
    }

    public T withReason(String reason) {
        this.reason = reason;
        return (T)this;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public T withStartTime(String startTime) {
        this.startTime = startTime;
        return (T)this;
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodStatusFluent that = (PodStatusFluent)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.containerStatuses != null ? !this.containerStatuses.equals(that.containerStatuses) : that.containerStatuses != null) {
            return false;
        }
        if (this.hostIP != null ? !this.hostIP.equals(that.hostIP) : that.hostIP != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.podIP != null ? !this.podIP.equals(that.podIP) : that.podIP != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class ContainerStatusesNested<N>
    extends ContainerStatusFluent<ContainerStatusesNested<N>>
    implements Nested<N> {
        private final ContainerStatusBuilder builder;

        ContainerStatusesNested() {
            this.builder = new ContainerStatusBuilder(this);
        }

        ContainerStatusesNested(ContainerStatus item) {
            this.builder = new ContainerStatusBuilder(this, item);
        }

        public N endContainerStatuse() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PodStatusFluent.this.addToContainerStatuses(this.builder.build());
        }
    }

    public class ConditionsNested<N>
    extends PodConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        private final PodConditionBuilder builder;

        ConditionsNested() {
            this.builder = new PodConditionBuilder(this);
        }

        ConditionsNested(PodCondition item) {
            this.builder = new PodConditionBuilder(this, item);
        }

        public N endCondition() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PodStatusFluent.this.addToConditions(this.builder.build());
        }
    }
}

