package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ContainerStatusFluent<T extends ContainerStatusFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     String containerID;     String image;     String imageID;     VisitableBuilder<ContainerState, ?> lastState;     String name;     Boolean ready;     Integer restartCount;     VisitableBuilder<ContainerState, ?> state;     Map<String, Object> additionalProperties = new HashMap();

    public String getContainerID(){
    return this.containerID;
    }
    public T withContainerID( String containerID){
    this.containerID=containerID; return (T) this;
    }
    public String getImage(){
    return this.image;
    }
    public T withImage( String image){
    this.image=image; return (T) this;
    }
    public String getImageID(){
    return this.imageID;
    }
    public T withImageID( String imageID){
    this.imageID=imageID; return (T) this;
    }
    public ContainerState getLastState(){
    return this.lastState!=null?this.lastState.build():null;
    }
    public T withLastState( ContainerState lastState){
    if (lastState!=null){ this.lastState= new ContainerStateBuilder(lastState); _visitables.add(this.lastState);} return (T) this;
    }
    public LastStateNested<T> withNewLastState(){
    return new LastStateNested<T>();
    }
    public LastStateNested<T> withNewLastStateLike( ContainerState item){
    return new LastStateNested<T>(item);
    }
    public LastStateNested<T> editLastState(){
    return withNewLastStateLike(getLastState());
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public Boolean isReady(){
    return this.ready;
    }
    public T withReady( Boolean ready){
    this.ready=ready; return (T) this;
    }
    public Integer getRestartCount(){
    return this.restartCount;
    }
    public T withRestartCount( Integer restartCount){
    this.restartCount=restartCount; return (T) this;
    }
    public ContainerState getState(){
    return this.state!=null?this.state.build():null;
    }
    public T withState( ContainerState state){
    if (state!=null){ this.state= new ContainerStateBuilder(state); _visitables.add(this.state);} return (T) this;
    }
    public StateNested<T> withNewState(){
    return new StateNested<T>();
    }
    public StateNested<T> withNewStateLike( ContainerState item){
    return new StateNested<T>(item);
    }
    public StateNested<T> editState(){
    return withNewStateLike(getState());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class LastStateNested<N> extends ContainerStateFluent<LastStateNested<N>> implements Nested<N>{

        private final ContainerStateBuilder builder;
    
             LastStateNested (){
        this.builder = new ContainerStateBuilder(this);
        }
             LastStateNested ( ContainerState item){
        this.builder = new ContainerStateBuilder(this, item);
        }
    
            public N endLastState(){
            return and();
        }
            public N and(){
            return (N) ContainerStatusFluent.this.withLastState(builder.build());
        }
    
}
    public class StateNested<N> extends ContainerStateFluent<StateNested<N>> implements Nested<N>{

        private final ContainerStateBuilder builder;
    
             StateNested (){
        this.builder = new ContainerStateBuilder(this);
        }
             StateNested ( ContainerState item){
        this.builder = new ContainerStateBuilder(this, item);
        }
    
            public N endState(){
            return and();
        }
            public N and(){
            return (N) ContainerStatusFluent.this.withState(builder.build());
        }
    
}


}
