package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ProbeBuilder extends ProbeFluent<ProbeBuilder> implements VisitableBuilder<Probe,ProbeBuilder>{

     ProbeFluent<?> fluent;
public ProbeBuilder(){
    this(new Probe());
}
public ProbeBuilder( ProbeFluent<?> fluent ){
    this(fluent, new Probe());
}
public ProbeBuilder( ProbeFluent<?> fluent , Probe instance ){
    this.fluent = fluent; fluent.withExec(instance.getExec()); fluent.withHttpGet(instance.getHttpGet()); fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds()); fluent.withTcpSocket(instance.getTcpSocket()); fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
}
public ProbeBuilder( Probe instance ){
    this.fluent = this; this.withExec(instance.getExec()); this.withHttpGet(instance.getHttpGet()); this.withInitialDelaySeconds(instance.getInitialDelaySeconds()); this.withTcpSocket(instance.getTcpSocket()); this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
}

public EditableProbe build(){
    EditableProbe buildable = new EditableProbe(fluent.getExec(),fluent.getHttpGet(),fluent.getInitialDelaySeconds(),fluent.getTcpSocket(),fluent.getTimeoutSeconds());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    