package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class BuildConfigSpecBuilder extends BuildConfigSpecFluent<BuildConfigSpecBuilder> implements VisitableBuilder<BuildConfigSpec,BuildConfigSpecBuilder>{

     BuildConfigSpecFluent<?> fluent;
public BuildConfigSpecBuilder(){
    this(new BuildConfigSpec());
}
public BuildConfigSpecBuilder( BuildConfigSpecFluent<?> fluent ){
    this(fluent, new BuildConfigSpec());
}
public BuildConfigSpecBuilder( BuildConfigSpecFluent<?> fluent , BuildConfigSpec instance ){
    this.fluent = fluent; fluent.withOutput(instance.getOutput()); fluent.withResources(instance.getResources()); fluent.withRevision(instance.getRevision()); fluent.withServiceAccount(instance.getServiceAccount()); fluent.withSource(instance.getSource()); fluent.withStrategy(instance.getStrategy()); fluent.withTriggers(instance.getTriggers()); 
}
public BuildConfigSpecBuilder( BuildConfigSpec instance ){
    this.fluent = this; this.withOutput(instance.getOutput()); this.withResources(instance.getResources()); this.withRevision(instance.getRevision()); this.withServiceAccount(instance.getServiceAccount()); this.withSource(instance.getSource()); this.withStrategy(instance.getStrategy()); this.withTriggers(instance.getTriggers()); 
}

public EditableBuildConfigSpec build(){
    EditableBuildConfigSpec buildable = new EditableBuildConfigSpec(fluent.getOutput(),fluent.getResources(),fluent.getRevision(),fluent.getServiceAccount(),fluent.getSource(),fluent.getStrategy(),fluent.getTriggers());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    