package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ImageBuilder extends ImageFluent<ImageBuilder> implements VisitableBuilder<Image,ImageBuilder>{

     ImageFluent<?> fluent;
public ImageBuilder(){
    this(new Image());
}
public ImageBuilder( ImageFluent<?> fluent ){
    this(fluent, new Image());
}
public ImageBuilder( ImageFluent<?> fluent , Image instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withDockerImageManifest(instance.getDockerImageManifest()); fluent.withDockerImageMetadata(instance.getDockerImageMetadata()); fluent.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion()); fluent.withDockerImageReference(instance.getDockerImageReference()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); 
}
public ImageBuilder( Image instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withDockerImageManifest(instance.getDockerImageManifest()); this.withDockerImageMetadata(instance.getDockerImageMetadata()); this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion()); this.withDockerImageReference(instance.getDockerImageReference()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); 
}

public EditableImage build(){
    EditableImage buildable = new EditableImage(fluent.getApiVersion(),fluent.getDockerImageManifest(),fluent.getDockerImageMetadata(),fluent.getDockerImageMetadataVersion(),fluent.getDockerImageReference(),fluent.getKind(),fluent.getMetadata());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    