package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class OAuthClientAuthorizationBuilder extends OAuthClientAuthorizationFluent<OAuthClientAuthorizationBuilder> implements VisitableBuilder<OAuthClientAuthorization,OAuthClientAuthorizationBuilder>{

     OAuthClientAuthorizationFluent<?> fluent;
public OAuthClientAuthorizationBuilder(){
    this(new OAuthClientAuthorization());
}
public OAuthClientAuthorizationBuilder( OAuthClientAuthorizationFluent<?> fluent ){
    this(fluent, new OAuthClientAuthorization());
}
public OAuthClientAuthorizationBuilder( OAuthClientAuthorizationFluent<?> fluent , OAuthClientAuthorization instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withClientName(instance.getClientName()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); fluent.withScopes(instance.getScopes()); fluent.withUserName(instance.getUserName()); fluent.withUserUID(instance.getUserUID()); 
}
public OAuthClientAuthorizationBuilder( OAuthClientAuthorization instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withClientName(instance.getClientName()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withScopes(instance.getScopes()); this.withUserName(instance.getUserName()); this.withUserUID(instance.getUserUID()); 
}

public EditableOAuthClientAuthorization build(){
    EditableOAuthClientAuthorization buildable = new EditableOAuthClientAuthorization(fluent.getApiVersion(),fluent.getClientName(),fluent.getKind(),fluent.getMetadata(),fluent.getScopes(),fluent.getUserName(),fluent.getUserUID());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    