package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class TLSConfigBuilder extends TLSConfigFluent<TLSConfigBuilder> implements VisitableBuilder<TLSConfig,TLSConfigBuilder>{

     TLSConfigFluent<?> fluent;
public TLSConfigBuilder(){
    this(new TLSConfig());
}
public TLSConfigBuilder( TLSConfigFluent<?> fluent ){
    this(fluent, new TLSConfig());
}
public TLSConfigBuilder( TLSConfigFluent<?> fluent , TLSConfig instance ){
    this.fluent = fluent; fluent.withCaCertificate(instance.getCaCertificate()); fluent.withCertificate(instance.getCertificate()); fluent.withDestinationCACertificate(instance.getDestinationCACertificate()); fluent.withKey(instance.getKey()); fluent.withTermination(instance.getTermination()); 
}
public TLSConfigBuilder( TLSConfig instance ){
    this.fluent = this; this.withCaCertificate(instance.getCaCertificate()); this.withCertificate(instance.getCertificate()); this.withDestinationCACertificate(instance.getDestinationCACertificate()); this.withKey(instance.getKey()); this.withTermination(instance.getTermination()); 
}

public EditableTLSConfig build(){
    EditableTLSConfig buildable = new EditableTLSConfig(fluent.getCaCertificate(),fluent.getCertificate(),fluent.getDestinationCACertificate(),fluent.getKey(),fluent.getTermination());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    