
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "args",
    "command",
    "env",
    "image",
    "imagePullPolicy",
    "lifecycle",
    "livenessProbe",
    "name",
    "ports",
    "readinessProbe",
    "resources",
    "securityContext",
    "terminationMessagePath",
    "volumeMounts",
    "workingDir"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
public class Container {

    /**
     * command array; the docker image's cmd is used if this is not provided; arguments to the entrypoint; cannot be updated; variable references $(VAR_NAME) are expanded using the container's environment variables; if a variable cannot be resolved
     * 
     */
    @JsonProperty("args")
    @Valid
    private List<String> args = new ArrayList<String>();
    /**
     * entrypoint array; not executed within a shell; the docker image's entrypoint is used if this is not provided; cannot be updated; variable references $(VAR_NAME) are expanded using the container's environment variables; if a variable cannot be resolved
     * 
     */
    @JsonProperty("command")
    @Valid
    private List<String> command = new ArrayList<String>();
    /**
     * list of environment variables to set in the container; cannot be updated
     * 
     */
    @JsonProperty("env")
    @Valid
    private List<EnvVar> env = new ArrayList<EnvVar>();
    /**
     * Docker image name; see http://releases.k8s.io/v1.0.0/docs/images.md
     * 
     */
    @JsonProperty("image")
    private String image;
    /**
     * image pull policy; one of Always
     * 
     */
    @JsonProperty("imagePullPolicy")
    private String imagePullPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("lifecycle")
    @Valid
    private Lifecycle lifecycle;
    /**
     * 
     * 
     */
    @JsonProperty("livenessProbe")
    @Valid
    private Probe livenessProbe;
    /**
     * name of the container; must be a DNS_LABEL and unique within the pod; cannot be updated
     * 
     */
    @JsonProperty("name")
    @Pattern(regexp = "^[a-z0-9]([-a-z0-9]*[a-z0-9])?$")
    @Size(max = 63)
    private String name;
    /**
     * list of ports to expose from the container; cannot be updated
     * 
     */
    @JsonProperty("ports")
    @Valid
    private List<ContainerPort> ports = new ArrayList<ContainerPort>();
    /**
     * 
     * 
     */
    @JsonProperty("readinessProbe")
    @Valid
    private Probe readinessProbe;
    /**
     * 
     * 
     */
    @JsonProperty("resources")
    @Valid
    private ResourceRequirements resources;
    /**
     * 
     * 
     */
    @JsonProperty("securityContext")
    @Valid
    private SecurityContext securityContext;
    /**
     * path at which the file to which the container's termination message will be written is mounted into the container's filesystem; message written is intended to be brief final status
     * 
     */
    @JsonProperty("terminationMessagePath")
    private String terminationMessagePath;
    /**
     * pod volumes to mount into the container's filesyste; cannot be updated
     * 
     */
    @JsonProperty("volumeMounts")
    @Valid
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    /**
     * container's working directory; defaults to image's default; cannot be updated
     * 
     */
    @JsonProperty("workingDir")
    private String workingDir;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public Container() {
    }

    /**
     * 
     * @param volumeMounts
     * @param resources
     * @param args
     * @param imagePullPolicy
     * @param image
     * @param securityContext
     * @param env
     * @param terminationMessagePath
     * @param readinessProbe
     * @param livenessProbe
     * @param ports
     * @param lifecycle
     * @param name
     * @param command
     * @param workingDir
     */
    public Container(List<String> args, List<String> command, List<EnvVar> env, String image, String imagePullPolicy, Lifecycle lifecycle, Probe livenessProbe, String name, List<ContainerPort> ports, Probe readinessProbe, ResourceRequirements resources, SecurityContext securityContext, String terminationMessagePath, List<VolumeMount> volumeMounts, String workingDir) {
        this.args = args;
        this.command = command;
        this.env = env;
        this.image = image;
        this.imagePullPolicy = imagePullPolicy;
        this.lifecycle = lifecycle;
        this.livenessProbe = livenessProbe;
        this.name = name;
        this.ports = ports;
        this.readinessProbe = readinessProbe;
        this.resources = resources;
        this.securityContext = securityContext;
        this.terminationMessagePath = terminationMessagePath;
        this.volumeMounts = volumeMounts;
        this.workingDir = workingDir;
    }

    /**
     * command array; the docker image's cmd is used if this is not provided; arguments to the entrypoint; cannot be updated; variable references $(VAR_NAME) are expanded using the container's environment variables; if a variable cannot be resolved
     * 
     * @return
     *     The args
     */
    @JsonProperty("args")
    public List<String> getArgs() {
        return args;
    }

    /**
     * command array; the docker image's cmd is used if this is not provided; arguments to the entrypoint; cannot be updated; variable references $(VAR_NAME) are expanded using the container's environment variables; if a variable cannot be resolved
     * 
     * @param args
     *     The args
     */
    @JsonProperty("args")
    public void setArgs(List<String> args) {
        this.args = args;
    }

    /**
     * entrypoint array; not executed within a shell; the docker image's entrypoint is used if this is not provided; cannot be updated; variable references $(VAR_NAME) are expanded using the container's environment variables; if a variable cannot be resolved
     * 
     * @return
     *     The command
     */
    @JsonProperty("command")
    public List<String> getCommand() {
        return command;
    }

    /**
     * entrypoint array; not executed within a shell; the docker image's entrypoint is used if this is not provided; cannot be updated; variable references $(VAR_NAME) are expanded using the container's environment variables; if a variable cannot be resolved
     * 
     * @param command
     *     The command
     */
    @JsonProperty("command")
    public void setCommand(List<String> command) {
        this.command = command;
    }

    /**
     * list of environment variables to set in the container; cannot be updated
     * 
     * @return
     *     The env
     */
    @JsonProperty("env")
    public List<EnvVar> getEnv() {
        return env;
    }

    /**
     * list of environment variables to set in the container; cannot be updated
     * 
     * @param env
     *     The env
     */
    @JsonProperty("env")
    public void setEnv(List<EnvVar> env) {
        this.env = env;
    }

    /**
     * Docker image name; see http://releases.k8s.io/v1.0.0/docs/images.md
     * 
     * @return
     *     The image
     */
    @JsonProperty("image")
    public String getImage() {
        return image;
    }

    /**
     * Docker image name; see http://releases.k8s.io/v1.0.0/docs/images.md
     * 
     * @param image
     *     The image
     */
    @JsonProperty("image")
    public void setImage(String image) {
        this.image = image;
    }

    /**
     * image pull policy; one of Always
     * 
     * @return
     *     The imagePullPolicy
     */
    @JsonProperty("imagePullPolicy")
    public String getImagePullPolicy() {
        return imagePullPolicy;
    }

    /**
     * image pull policy; one of Always
     * 
     * @param imagePullPolicy
     *     The imagePullPolicy
     */
    @JsonProperty("imagePullPolicy")
    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    /**
     * 
     * 
     * @return
     *     The lifecycle
     */
    @JsonProperty("lifecycle")
    public Lifecycle getLifecycle() {
        return lifecycle;
    }

    /**
     * 
     * 
     * @param lifecycle
     *     The lifecycle
     */
    @JsonProperty("lifecycle")
    public void setLifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    /**
     * 
     * 
     * @return
     *     The livenessProbe
     */
    @JsonProperty("livenessProbe")
    public Probe getLivenessProbe() {
        return livenessProbe;
    }

    /**
     * 
     * 
     * @param livenessProbe
     *     The livenessProbe
     */
    @JsonProperty("livenessProbe")
    public void setLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    /**
     * name of the container; must be a DNS_LABEL and unique within the pod; cannot be updated
     * 
     * @return
     *     The name
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * name of the container; must be a DNS_LABEL and unique within the pod; cannot be updated
     * 
     * @param name
     *     The name
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * list of ports to expose from the container; cannot be updated
     * 
     * @return
     *     The ports
     */
    @JsonProperty("ports")
    public List<ContainerPort> getPorts() {
        return ports;
    }

    /**
     * list of ports to expose from the container; cannot be updated
     * 
     * @param ports
     *     The ports
     */
    @JsonProperty("ports")
    public void setPorts(List<ContainerPort> ports) {
        this.ports = ports;
    }

    /**
     * 
     * 
     * @return
     *     The readinessProbe
     */
    @JsonProperty("readinessProbe")
    public Probe getReadinessProbe() {
        return readinessProbe;
    }

    /**
     * 
     * 
     * @param readinessProbe
     *     The readinessProbe
     */
    @JsonProperty("readinessProbe")
    public void setReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    /**
     * 
     * 
     * @return
     *     The resources
     */
    @JsonProperty("resources")
    public ResourceRequirements getResources() {
        return resources;
    }

    /**
     * 
     * 
     * @param resources
     *     The resources
     */
    @JsonProperty("resources")
    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    /**
     * 
     * 
     * @return
     *     The securityContext
     */
    @JsonProperty("securityContext")
    public SecurityContext getSecurityContext() {
        return securityContext;
    }

    /**
     * 
     * 
     * @param securityContext
     *     The securityContext
     */
    @JsonProperty("securityContext")
    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    /**
     * path at which the file to which the container's termination message will be written is mounted into the container's filesystem; message written is intended to be brief final status
     * 
     * @return
     *     The terminationMessagePath
     */
    @JsonProperty("terminationMessagePath")
    public String getTerminationMessagePath() {
        return terminationMessagePath;
    }

    /**
     * path at which the file to which the container's termination message will be written is mounted into the container's filesystem; message written is intended to be brief final status
     * 
     * @param terminationMessagePath
     *     The terminationMessagePath
     */
    @JsonProperty("terminationMessagePath")
    public void setTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
    }

    /**
     * pod volumes to mount into the container's filesyste; cannot be updated
     * 
     * @return
     *     The volumeMounts
     */
    @JsonProperty("volumeMounts")
    public List<VolumeMount> getVolumeMounts() {
        return volumeMounts;
    }

    /**
     * pod volumes to mount into the container's filesyste; cannot be updated
     * 
     * @param volumeMounts
     *     The volumeMounts
     */
    @JsonProperty("volumeMounts")
    public void setVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    /**
     * container's working directory; defaults to image's default; cannot be updated
     * 
     * @return
     *     The workingDir
     */
    @JsonProperty("workingDir")
    public String getWorkingDir() {
        return workingDir;
    }

    /**
     * container's working directory; defaults to image's default; cannot be updated
     * 
     * @param workingDir
     *     The workingDir
     */
    @JsonProperty("workingDir")
    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
